/***************************************************************************
 *   Copyright (C) 2002-2004 by Alexander Dymo                             *
 *   cloudtemple@mskat.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Library General Public     *
 *   License along with this program; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#include "plineedit.h"

#include <klineedit.h>
#include <tqlayout.h>

namespace PropertyLib{

PLineEdit::PLineEdit(MultiProperty *property, TQWidget *parent, const char *name)
    :PropertyWidget(property, parent, name)
{
    TQHBoxLayout *l = new TQHBoxLayout(this, 0, 0);
    m_edit = new KLineEdit(this);
    m_edit->setSizePolicy(TQSizePolicy::MinimumExpanding, TQSizePolicy::MinimumExpanding);
    l->addWidget(m_edit);
    
    connect(m_edit, TQT_SIGNAL(textChanged(const TQString&)), this, TQT_SLOT(updateProperty(const TQString&)));
}

TQVariant PLineEdit::value() const
{
    return TQVariant(m_edit->text());
}

void PLineEdit::setValue(const TQVariant &value, bool emitChange)
{
    disconnect(m_edit, TQT_SIGNAL(textChanged(const TQString&)), this, TQT_SLOT(updateProperty(const TQString&)));
    m_edit->setText(value.toString());
    connect(m_edit, TQT_SIGNAL(textChanged(const TQString&)), this, TQT_SLOT(updateProperty(const TQString&)));
    if (emitChange)
        emit propertyChanged(m_property, value);
}

void PLineEdit::updateProperty(const TQString& val)
{
    emit propertyChanged(m_property, TQVariant(val));
}

}

#ifndef PURE_QT
#include "plineedit.moc"
#endif
