/**********************************************************************
** Copyright (C) 2000-2002 Trolltech AS.  All rights reserved.
**
** This file is part of TQt Designer.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid TQt Enterprise Edition or TQt Professional Edition
** licenses may use this file in accordance with the TQt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about TQt Commercial License Agreements.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#include "widgetaction.h"
#include <tqwidget.h>
#include <tqtoolbutton.h>
#include "mainwindow.h"
#include <tqstylefactory.h>
#include <tqstyle.h>

static TQStyle *windowsStyle = 0;

void WidgetAction::addedTo( TQWidget *w, TQWidget *container )
{
    if ( ::tqqt_cast<TQToolButton*>(w) && ::tqqt_cast<TQScrollView*>(container->parent()->parent()) ) {
	if ( !windowsStyle )
	    windowsStyle = TQStyleFactory::create( "windows" );
	w->setStyle( windowsStyle );
	( (TQToolButton*)w )->setUsesTextLabel( TRUE );
	( (TQToolButton*)w )->setTextPosition( TQToolButton::Right );
	w->setBackgroundMode( container->backgroundMode() );
    }
}

WidgetAction::~WidgetAction()
{
    if ( MainWindow::self )
	MainWindow::self->toolActions.removeRef( this );
}

void WidgetAction::init( const TQString &g )
{
    MainWindow::self->toolActions.append( this );
    grp = g;
}
