/***************************************************************************
 *   Copyright (C) 2004 by Alexander Dymo                                  *
 *   cloudtemple@mksat.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#ifndef DOCCHMPLUGIN_H
#define DOCCHMPLUGIN_H

#include <kdevdocumentationplugin.h>

class DocCHMPlugin :public DocumentationPlugin
{
    Q_OBJECT
  
public:
    DocCHMPlugin(TQObject* parent, const char* name, TQStringList args = TQStringList());
    ~DocCHMPlugin();
    
    virtual TQString pluginName() const;

    virtual void setCatalogURL(DocumentationCatalogItem* item);
    virtual TQString catalogTitle(const TQString& url);
    virtual TQPair<KFile::Mode, TQString> catalogLocatorProps();
    virtual DocumentationCatalogItem* createCatalog(TDEListView* contents, TDEListViewItem *after, const TQString& title, const TQString& url);
    virtual void createTOC(DocumentationCatalogItem* item);
    
    virtual void createIndex(IndexBox* index, DocumentationCatalogItem* item);
    virtual bool needRefreshIndex(DocumentationCatalogItem* item);
    
    virtual TQStringList fullTextSearchLocations();
    
    virtual void autoSetupPlugin();
    
    virtual ProjectDocumentationPlugin* projectDocumentationPlugin(ProjectDocType type);
    
protected:
    TQString getSpecialData(const TQString& name, KURL url);
};

#endif
