/***************************************************************************
 *   Copyright (C) 2004 by Alexander Dymo                                  *
 *   cloudtemple@mskat.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Library General Public     *
 *   License along with this program; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#include "plinestyleedit.h"

#include <tqpainter.h>
#include <tqpixmap.h>
#include <tqcombobox.h>
#include <tqlayout.h>

namespace PropertyLib {

    const char *nopen[]={
    "48 16 1 1",
    ". c None",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................"};
    const char *solid[]={
    "48 16 2 1",
    ". c None",
    "# c #000000",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    ".###########################################....",
    ".###########################################....",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................"};
    const char *dash[]={
    "48 16 2 1",
    ". c None",
    "# c #000000",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    ".#########..#########..#########..##########....",
    ".#########..#########..#########..##########....",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................"};
    const char *dashdot[]={
    "48 16 2 1",
    ". c None",
    "# c #000000",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    ".#########..##..#########..##..#########..##....",
    ".#########..##..#########..##..#########..##....",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................"};
    const char *dashdotdot[]={
    "48 16 2 1",
    ". c None",
    "# c #000000",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    ".#########..##..##..#########..##..##..#####....",
    ".#########..##..##..#########..##..##..#####....",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................"};


PLineStyleEdit::PLineStyleEdit(MultiProperty* property, TQWidget* parent, const char* name): PropertyWidget(property, parent, name)
{
    TQHBoxLayout *l = new TQHBoxLayout(this, 0, 0);
    m_edit = new TQComboBox(this);
    m_edit->setSizePolicy(TQSizePolicy::MinimumExpanding, TQSizePolicy::MinimumExpanding);
    l->addWidget(m_edit);

    m_edit->insertItem(TQPixmap(nopen));
    m_edit->insertItem(TQPixmap(solid));
    m_edit->insertItem(TQPixmap(dash));
    m_edit->insertItem(TQPixmap(dashdot));
    m_edit->insertItem(TQPixmap(dashdotdot));    

    connect(m_edit, TQT_SIGNAL(activated(int)), this, TQT_SLOT(updateProperty(int)));
}

TQVariant PLineStyleEdit::value() const
{
    return m_edit->currentItem();
}

void PLineStyleEdit::drawViewer(TQPainter* p, const TQColorGroup& cg, const TQRect& r, const TQVariant& value)
{
    p->setPen(TQt::NoPen);
    p->setBrush(cg.background());
    p->drawRect(r);
    
    if (!value.canCast(TQVariant::Int))
    if ((value.toInt() > 5) || (value.toInt() < 0))
        return;
    
    switch (value.toInt()) {
    case 0:
        p->drawPixmap(r, TQPixmap(nopen));
        break;
    case 1:
        p->drawPixmap(r, TQPixmap(solid));
        break;
    case 2:
        p->drawPixmap(r, TQPixmap(dash));
        break;
    case 3:
        p->drawPixmap(r, TQPixmap(dashdot));
        break;
    case 4:
        p->drawPixmap(r, TQPixmap(dashdot));
        break;
    case 5:
        p->drawPixmap(r, TQPixmap(dashdotdot));
        break;
    }
}

void PLineStyleEdit::setValue(const TQVariant& value, bool emitChange)
{
    if (!value.canCast(TQVariant::Int))
        return;
    if ((value.toInt() > 5) || (value.toInt() < 0))
        return;
    disconnect(m_edit, TQT_SIGNAL(activated(int)), this, TQT_SLOT(updateProperty(int)));
    m_edit->setCurrentItem(value.toInt());
    connect(m_edit, TQT_SIGNAL(activated(int)), this, TQT_SLOT(updateProperty(int)));
    if (emitChange)
        emit propertyChanged(m_property, value);
}

void PLineStyleEdit::updateProperty(int val)
{
    emit propertyChanged(m_property, TQVariant(val));
}

}

#ifndef PURE_QT
#include "plinestyleedit.moc"
#endif
