/*
 * Port for usage with qt-framework and development for tdesvn
 * (C) 2005-2007 by Rajko Albrecht
 * http://tdesvn.alwins-world.de
 */
/*
 * ====================================================================
 * Copyright (c) 2002-2005 The RapidSvn Group.  All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library (in the file LGPL.txt); if not,
 * write to the Free Software Foundation, Inc., 51 Franklin St,
 * Fifth Floor, Boston, MA  02110-1301  USA
 *
 * This software consists of voluntary contributions made by many
 * individuals.  For exact contribution history, see the revision
 * history and logs, available at http://rapidsvn.tigris.org/.
 * ====================================================================
 */

#ifndef _SVNCPP_URL_H_
#define _SVNCPP_URL_H_

#include "svnqt/svnqt_defines.hpp"

// qt
#include <tqglobal.h>

#include <tqstring.h>
#include <tqvaluelist.h>

namespace svn
{
  class SVNTQT_EXPORT Url
  {
  public:
    /** Constructor */
    Url ();

    /** Destructor */
    virtual ~Url ();

    /**
     * Checks if @a url is valid
     *
     * Example of a valid URL:
     *   http://svn.collab.net/repos/svn
     * Example of an invalid URL:
     *   /home/foo/bar
     */
    static bool
    isValid (const TQString& url);

    /**
     * Checks if @a url points to a local filesystem.
     *
     * @return true if url is accessed local without network.
     */
    static bool
    isLocal(const TQString& url);

    static TQString
    transformProtokoll(const TQString&);

    /**
     * returns a vector with url schemas that are
     * supported by svn
     *
     * @return vector with entries like "file:", "http:"
     */
    static TQValueList<TQString>
    supportedSchemas ();
  };
}

#endif
