/***************************************************************************
 *   Copyright (C) 2005-2007 by Rajko Albrecht                             *
 *   ral@alwins-world.de                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.         *
 ***************************************************************************/
#ifndef LOGMSG_IMPL_H
#define LOGMSG_IMPL_H

#include "logmessage.h"
#include "commititem.h"
#include <tqvaluelist.h>
#include <tqpair.h>

class Logmsg_impl: public LogmessageData {
Q_OBJECT
  
public:
    struct logActionEntry {
        TQString _name;
        TQString _actionDesc;

        enum ACTION_TYPE{
            COMMIT=0,
            ADD_COMMIT=1,
            DELETE=2,
            MISSING_DELETE=3
        };
        ACTION_TYPE _kind;
        logActionEntry(const TQString&,const TQString&,ACTION_TYPE kind = COMMIT);
        logActionEntry();
    };

    typedef TQValueList<logActionEntry> logActionEntries;

    Logmsg_impl(TQWidget *parent = 0, const char *name = 0);
    Logmsg_impl(const svn::CommitItemList&_items,TQWidget *parent=0, const char *name=0);
    Logmsg_impl(const TQMap<TQString,TQString>&_items,TQWidget *parent=0, const char *name=0);
    Logmsg_impl(const logActionEntries&,
        const logActionEntries&,
        TQWidget *parent = 0, const char *name = 0);
    virtual ~Logmsg_impl();

    TQString getMessage()const;
    bool isKeeplocks()const;
    void initHistory();
    void saveHistory(bool canceld);

    static TQString getLogmessage(bool*ok,svn::Depth*rec,bool*keeps_locks,TQWidget*parent=0,const char*name=0);
    static TQString getLogmessage(const svn::CommitItemList&,bool*ok,svn::Depth*rec,bool*keep_locks,TQWidget*parent=0,const char*name=0);
    static TQString getLogmessage(const TQMap<TQString,TQString>&,bool*ok,svn::Depth*rec,bool*keep_locks,TQWidget*parent=0,const char*name=0);

    static TQString getLogmessage(const logActionEntries&,
            const logActionEntries&,
            TQObject*callback,
            logActionEntries&,
            bool*ok,bool*keep_locks,TQWidget*parent=0,const char*name=0);

    void addItemWidget(TQWidget*);

    svn::Depth getDepth()const;

    logActionEntries selectedEntries();
    void hideDepth(bool ahide);

protected slots:
    virtual void slotHistoryActivated(int);
    virtual void slotUnmarkUnversioned();
    virtual void slotDiffSelected();
    virtual void slotMarkUnversioned();
    virtual void hideNewItems(bool);
    virtual void insertFile();

protected:
    static TQValueList<TQString> sLogHistory;
    TQValueList<TQListViewItem*> m_Hidden;
    static const TQString groupName;
    static TQString sLastMessage;
    static unsigned int smax_message_history;
    bool m_hidden;

    void hideButtons(bool);
    void markUnversioned(bool mark);
    void checkSplitterSize();
    virtual void insertFile(const TQString&);
signals:
    void makeDiff(const TQString&,const svn::Revision&,const TQString&,const svn::Revision&,TQWidget*);
};

#endif
