/*
 * $Id$
 *
 * KDE3 Style Guide compliance check "Style", v0.0.1
 *        Copyright (C) 2002 Maksim Orlovich <orlovich@cs.rochester.edu>
 *                         (C) 2002 Ryan Cumming <bodnar42@phalynx.dhs.org>
 *
 *
 * Based on the KDE3 HighColor Style (version 1.0):
 *      Copyright (C) 2001-2002 Karol Szwed      <gallium@kde.org>
 *                 (C) 2001-2002 Fredrik H�glund  <fredrik@kde.org>
 *
 *       Drawing routines adapted from the KDE2 HCStyle,
 *       Copyright (C) 2000 Daniel M. Duley       <mosfet@kde.org>
 *                 (C) 2000 Dirk Mueller          <mueller@kde.org>
 *                 (C) 2001 Martijn Klingens      <klingens@kde.org>
 *
 *  Portions of code are from the TQt GUI Toolkit,  Copyright (C) 1992-2000 Trolltech AS.
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; see the file COPYING.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 *
 */

#ifndef STYLE_CHECK_H
#define STYLE_CHECK_H

#include <tqbitmap.h>
#include <tqheader.h>
#include <tqintdict.h>
#include <tqvaluevector.h>
#include <tqguardedptr.h>

#include <kdrawutil.h>
#include <kpixmap.h>
#include <tdestyle.h>


class TQPopupMenu;

class StyleCheckTitleWatcher: public TQObject
{
	Q_OBJECT
  

	public:
		StyleCheckTitleWatcher();
		void addWatched(TQWidget* w);
	public slots:
		void slotCheck();
	private:
		TQString cleanErrorMarkers(TQString in);
		TQValueVector<TQGuardedPtr<TQWidget> > watched;
		TQValueVector<TQString> watchedTitles;
};

class StyleCheckStyle : public TDEStyle
{
	Q_OBJECT
  

	public:
		StyleCheckStyle( );
		virtual ~StyleCheckStyle();

		void polish( const TQStyleControlElementData &ceData, ControlElementFlags elementFlags, void * );
		void unPolish( const TQStyleControlElementData &ceData, ControlElementFlags elementFlags, void * );


		void drawTDEStylePrimitive( TDEStylePrimitive kpe,
					TQPainter* p,
					const TQStyleControlElementData &ceData,
					ControlElementFlags elementFlags,
					const TQRect &r,
					const TQColorGroup &cg,
					SFlags flags = Style_Default,
					const TQStyleOption& = TQStyleOption::Default,
					const TQWidget* widget = 0 ) const;

		void drawPrimitive( PrimitiveElement pe,
					TQPainter* p,
					const TQStyleControlElementData &ceData,
					ControlElementFlags elementFlags,
					const TQRect &r,
					const TQColorGroup &cg,
					SFlags flags = Style_Default,
					const TQStyleOption& = TQStyleOption::Default ) const;

		void drawControl( ControlElement element,
					TQPainter *p,
					const TQStyleControlElementData &ceData,
					ControlElementFlags elementFlags,
					const TQRect &r,
					const TQColorGroup &cg,
					SFlags flags = Style_Default,
					const TQStyleOption& = TQStyleOption::Default,
					const TQWidget *widget = 0 ) const;

		void drawControlMask( ControlElement element,
					TQPainter *p,
					const TQStyleControlElementData &ceData,
					ControlElementFlags elementFlags,
					const TQRect &r,
					const TQStyleOption& = TQStyleOption::Default,
					const TQWidget *widget = 0 ) const;

		void drawComplexControl( ComplexControl control,
					TQPainter *p,
					const TQStyleControlElementData &ceData,
					ControlElementFlags elementFlags,
					const TQRect &r,
					const TQColorGroup &cg,
					SFlags flags = Style_Default,
					SCFlags controls = SC_All,
					SCFlags active = SC_None,
					const TQStyleOption& = TQStyleOption::Default,
					const TQWidget *widget = 0 ) const;

		void drawComplexControlMask( ComplexControl control,
					TQPainter *p,
					const TQStyleControlElementData &ceData,
					const ControlElementFlags elementFlags,
					const TQRect &r,
					const TQStyleOption& = TQStyleOption::Default,
					const TQWidget *widget = 0 ) const;

		int pixelMetric( PixelMetric m, const TQStyleControlElementData &ceData, ControlElementFlags elementFlags,
					const TQWidget *widget = 0 ) const;

		TQSize sizeFromContents( ContentsType contents,
					const TQStyleControlElementData &ceData,
					ControlElementFlags elementFlags,
					const TQSize &contentSize,
					const TQStyleOption& opt,
					const TQWidget *widget = 0 ) const;

		TQRect subRect( SubRect r, const TQStyleControlElementData &ceData, const ControlElementFlags elementFlags,
					const TQWidget *widget ) const;

		// Fix TQt3's wacky image positions
		TQPixmap stylePixmap( StylePixmap stylepixmap,
					const TQStyleControlElementData &ceData, ControlElementFlags elementFlags,
					const TQStyleOption& = TQStyleOption::Default, const TQWidget *widget = 0 ) const;

	protected:
		virtual bool objectEventHandler( const TQStyleControlElementData &ceData, ControlElementFlags elementFlags, void* source, TQEvent *e );

		void renderGradient( TQPainter* p,
					const TQRect& r,
					TQColor clr,
					bool horizontal,
					int px=0,
					int py=0,
					int pwidth=-1,
					int pheight=-1 ) const;

		TQTimer     *topLevelAccelManageTimer;
		TQWidget    *hoverWidget;

	private slots:
		void slotAccelManage();
		
	private:
		void accelManageRecursive(TQWidget* widget);
            
		StyleCheckTitleWatcher* watcher;

		// Disable copy constructor and = operator
		StyleCheckStyle( const StyleCheckStyle & );
		StyleCheckStyle& operator=( const StyleCheckStyle & );
};

// vim: set noet ts=4 sw=4:
// kate: indent-width 4; replace-tabs off; tab-width 4; space-indent off;

#endif
