#ifndef __bugdetails_impl_h__
#define __bugdetails_impl_h__

#include <ksharedptr.h>

#include "bugdetailspart.h"

struct BugDetailsImpl : public TDEShared
{
public:
    BugDetailsImpl( const TQString &_version, const TQString &_source,
                    const TQString &_compiler, const TQString &_os,
                    const BugDetailsPart::List &_parts )
        : version( _version ), source( _source ), compiler( _compiler ),
          os( _os ), parts( _parts ) {}

    struct AttachmentDetails {
        AttachmentDetails() { }
        AttachmentDetails( const TQString& descr, const TQString& dt,
                           const TQString& idf ) : description( descr ),
                                                  date( dt ),
                                                  id( idf ) { }
        TQString description;
        TQString date;
        TQString id;
    };

    TQString version;
    TQString source;
    TQString compiler;
    TQString os;
    BugDetailsPart::List parts;
    TQValueList<BugDetailsImpl::AttachmentDetails> attachments;
};

#endif

/*
 * vim:sw=4:ts=4:et
 */
