/*
 * Copyright (c) 2003 Christian Loose <christian.loose@hamburg.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 *
 */

#include <tqregexp.h>
#include <tdeaboutdata.h>
#include <tdeapplication.h>
#include <tdecmdlineargs.h>
#include <tdelocale.h>
#include <kpassdlg.h>

#include <iostream>


static TDECmdLineOptions options[] =
{
    { "+[prompt]", I18N_NOOP("prompt"), 0 },
    TDECmdLineLastOption
};


extern "C" KDE_EXPORT int kdemain(int argc, char** argv)
{
    TDEAboutData about("cvsaskpass", I18N_NOOP("cvsaskpass"), "0.1",
                     I18N_NOOP("ssh-askpass for the CVS DCOP Service"),
                     TDEAboutData::License_LGPL,
                     I18N_NOOP("Copyright (c) 2003 Christian Loose"));

    TDECmdLineArgs::init(argc, argv, &about);
    TDECmdLineArgs::addCmdLineOptions(options);

    // no need to register with the dcop server
    TDEApplication::disableAutoDcopRegistration();
    TDEApplication app;

    // no need for session management
    app.disableSessionManagement();

    if( !TDECmdLineArgs::parsedArgs()->count() )
        return 1;

    // parse repository name from the passed argument
    TQString prompt = TDECmdLineArgs::parsedArgs()->arg(0);
    TQRegExp rx("(.*@.*)'s password:");
    int pos = rx.search(prompt);

    KPasswordDialog dlg(KPasswordDialog::Password, false, 0);
    dlg.setPrompt(i18n("Please type in your password below."));

    if( pos > -1 )
        dlg.addLine(i18n("Repository:"), rx.cap(1));

    int res = dlg.exec();
    if( res == KPasswordDialog::Accepted )
    {
        std::cout << dlg.password() << std::endl;
        return 0;
    }

    return 1;
}
