#################################################
#
#  (C) 2010 Serghei Amelian
#  serghei (DOT) amelian (AT) gmail.com
#
#  Improvements and feedback are welcome
#
#  This file is released under GPL >= 2
#
#################################################

##### check for gcc visibility support #########
# FIXME
# This should check for [T]Qt3 visibility support

if( WITH_GCC_VISIBILITY )
  if( NOT UNIX )
    tde_message_fatal(FATAL_ERROR "\ngcc visibility support was requested, but your system is not *NIX" )
  endif( NOT UNIX )
  set( __KDE_HAVE_GCC_VISIBILITY 1 )
  set( CMAKE_C_FLAGS "${CMAKE_C_FLAGS} -fvisibility=hidden -fvisibility-inlines-hidden")
  set( CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -fvisibility=hidden -fvisibility-inlines-hidden")
endif( )


# check for Xext
pkg_search_module( XEXT xext )
if( NOT XEXT_FOUND )
  tde_message_fatal( "Xext are required, but not found on your system" )
endif()


# check for Xtst
pkg_search_module( XTST xtst )
if( NOT XTST_FOUND )
  tde_message_fatal( "Xtst are required, but not found on your system" )
endif()


# check for xscrnsaver
pkg_search_module( XSCRNSAVER xscrnsaver )
if( NOT XSCRNSAVER_FOUND )
  tde_message_fatal( "xscrnsaver are required, but not found on your system" )
endif()


# check for dbus-1
pkg_search_module( DBUS dbus-1 )
if( NOT DBUS_FOUND )
  tde_message_fatal( "dbus-1 is required, but was not found on your system" )
endif( )


# check for dbus-1-tqt
pkg_search_module( DBUS_TQT dbus-1-tqt )
if( NOT DBUS_TQT_FOUND )
  tde_message_fatal( "dbus-1-tqt is required, but was not found on your system" )
endif( )

# check for msgfmt
if( BUILD_TRANSLATIONS AND NOT DEFINED MSGFMT_EXECUTABLE )
  find_program( MSGFMT_EXECUTABLE msgfmt )
  if( NOT MSGFMT_EXECUTABLE )
    tde_message_fatal( "msgfmt program is required, but was not found on your system" )
  endif( )
endif( )


# required stuff
find_package( TQt )
find_package( TDE )
