#################################################
#
#  (C) 2010-2011 Serghei Amelian
#  serghei (DOT) amelian (AT) gmail.com
#
#  Improvements and feedback are welcome
#
#  This file is released under GPL >= 2
#
#################################################

tde_setup_architecture_flags( )

include(TestBigEndian)
test_big_endian(WORDS_BIGENDIAN)

tde_setup_largefiles( )

check_symbol_exists( strlcpy "string.h" HAVE_STRLCPY_PROTO )
check_symbol_exists( strlcat "string.h" HAVE_STRLCAT_PROTO )

##### check for gcc visibility support #########

if( WITH_GCC_VISIBILITY )
  tde_setup_gcc_visibility( )
endif( )


if( BUILD_KMAIL )
  check_include_file( "byteswap.h" HAVE_BYTESWAP_H )
endif( )


if( BUILD_INDEXLIB OR BUILD_KMAIL )

  # check for stl coping with namespace std
  tde_save( CMAKE_CXX_FLAGS )
  string( REGEX REPLACE "-include tqt.h" "" CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS}" )
  check_cxx_source_compiles("
      #include <iterator>
      struct s : public std::iterator<std::forward_iterator_tag, int> {};
      int main(int, char**) { return 0; } "
      HAVE_STLNAMESPACE )
  tde_restore( CMAKE_CXX_FLAGS )
  if( HAVE_STLNAMESPACE )
    set( STD_NAMESPACE_PREFIX "std::" )
  endif( )

endif( )


if( BUILD_KMOBILE )
  # FIXME not checked because Gentoo don't provide baudboy.h
  check_include_file( "baudboy.h" HAVE_BAUDBOY_H )
endif( )


if( WITH_GNOKII AND (BUILD_KADDRESSBOOK OR BUILD_KMOBILE) )
  pkg_search_module( GNOKII gnokii )
  if( NOT GNOKII_FOUND )
    tde_message_fatal( "gnokii are requested, but was not found on your system" )
  endif( )
endif( )


if( BUILD_LIBTDENETWORK OR BUILD_CERTMANAGER OR BUILD_KMAIL OR BUILD_KADDRESSBOOK OR BUILD_KONTACT )

  if( NOT HAVE_GPGME_0_4_BRANCH )
    message( STATUS "checking for 'gpgme'" )
  endif( )

  # find gpgme-config
  find_program( GPGME_EXECUTABLE NAMES gpgme-config )
  if( NOT GPGME_EXECUTABLE )
    tde_message_fatal( "gpgme-config was NOT found.\n gpgme library is installed?" )
  endif( )

  # find gpg-error-config
  find_program( GPG_ERR_EXECUTABLE NAMES gpg-error-config )
  if( NOT GPG_ERR_EXECUTABLE )
    tde_message_fatal( "gpg-error-config was NOT found.\n gpg-error library is installed?" )
  endif( )

  macro( __run_gpgme_config  __type __var )
    execute_process(
      COMMAND ${GPGME_EXECUTABLE} --${__type}
      OUTPUT_VARIABLE ${__var}
      RESULT_VARIABLE __result
      OUTPUT_STRIP_TRAILING_WHITESPACE )
    if( _result )
      tde_message_fatal( "Unable to run ${GPGME_EXECUTABLE}!\n gpgme library incorrectly installed?\n Path to gpgme-config incorrect?" )
    endif( )
  endmacro( )

  macro( __run_gpgerr_config  __type __var )
    execute_process(
      COMMAND ${GPG_ERR_EXECUTABLE} --${__type}
      OUTPUT_VARIABLE ${__var}
      RESULT_VARIABLE __result
      OUTPUT_STRIP_TRAILING_WHITESPACE )
    if( _result )
      tde_message_fatal( "Unable to run ${GPG_ERR_EXECUTABLE}!\n gpg-error library incorrectly installed?\n Path to gpgme-config are incorrect?" )
    endif( )
  endmacro( )

  __run_gpgme_config( version GPGME_VERSION )
  __run_gpgme_config( cflags GPGME_INCLUDE_DIRS )
  __run_gpgme_config( libs GPGME_LIBRARIES )

  __run_gpgerr_config( version GPGERR_VERSION )
  __run_gpgerr_config( cflags GPGERR_INCLUDE_DIRS )
  __run_gpgerr_config( libs GPGERR_LIBRARIES )

  # cleanup
  if( GPGME_INCLUDE_DIRS )
    string( REGEX REPLACE "(^| )-I" ";" GPGME_INCLUDE_DIRS "${GPGME_INCLUDE_DIRS}" )
  endif( )
  if( GPGME_LIBRARIES )
    string( REGEX REPLACE "(^| )-l" ";" GPGME_LIBRARIES "${GPGME_LIBRARIES}" )
  endif( )
  if( GPGERR_INCLUDE_DIRS )
    string( REGEX REPLACE "(^| )-I" ";" GPGERR_INCLUDE_DIRS "${GPGERR_INCLUDE_DIRS}" )
  endif( )
  if( GPGERR_LIBRARIES )
    string( REGEX REPLACE "(^| )-l" ";" GPGERR_LIBRARIES "${GPGERR_LIBRARIES}" )
  endif( )
  set( GPGME_INCLUDE_DIRS "${GPGME_INCLUDE_DIRS} ${GPGERR_INCLUDE_DIRS}" CACHE INTERNAL "" FORCE )
  set( GPGME_LIBRARIES "${GPGME_LIBRARIES} ${GPGERR_LIBRARIES}" CACHE INTERNAL "" FORCE )
  string( REGEX REPLACE " ;" ";" GPGME_INCLUDE_DIRS "${GPGME_INCLUDE_DIRS}" )
  string( REGEX REPLACE " ;" ";" GPGME_LIBRARIES "${GPGME_LIBRARIES}" )
  set( GPGME_INCLUDE_DIRS "${GPGME_INCLUDE_DIRS}" CACHE INTERNAL "" FORCE )
  set( GPGME_LIBRARIES "${GPGME_LIBRARIES}" CACHE INTERNAL "" FORCE )

  # assuming that all newer system have gpgme >= 0.4
  set( HAVE_GPGME_0_4_BRANCH 1 CACHE INTERNAL "" )

  # NOTE: assume we have largefile support (need for gpgme)
  # FIXME: to be sure, we must check it
  add_definitions( -D_FILE_OFFSET_BITS=64 )

  if( NOT HAVE_GPGME_0_4_BRANCH )
    message( STATUS "  found 'gpgme', version ${GPGME_VERSION}" )
  endif( )

  # check for various GPGME features
  tde_save( CMAKE_CXX_FLAGS )
  tde_save( CMAKE_REQUIRED_LIBRARIES )
  string( REGEX REPLACE "-include tqt.h" "" CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS}" )
  # See FIXME above regarding -D_FILE_OFFSET_BITS=64
  set( CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} ${GPGME_INCLUDE_DIRS} -D_FILE_OFFSET_BITS=64")
  set( CMAKE_REQUIRED_LIBRARIES "${GPGME_LIBRARIES}")

  # check for GPGME_KEYLIST_MODE_VALIDATE
  check_cxx_source_compiles("
      #include <gpgme.h>
      int main() {
        gpgme_keylist_mode_t mode = GPGME_KEYLIST_MODE_VALIDATE;
      };"
      HAVE_GPGME_KEYLIST_MODE_VALIDATE )

  # check for gpgme_cancel
  check_cxx_source_compiles("
      #include <gpgme.h>
      int main() {
        gpgme_ctx_t ctx = 0;
        gpgme_error_t e = gpgme_cancel( ctx );
      };"
      HAVE_GPGME_CANCEL )

  # check for gpgme_key_t->keylist_mode
  check_cxx_source_compiles("
      #include <gpgme.h>
      int main() {
        gpgme_key_t key = 0;
        key->keylist_mode = 0;
      };"
      HAVE_GPGME_KEY_T_KEYLIST_MODE )

  # check for gpgme_decrypt_result_t->wrong_key_usage
  check_cxx_source_compiles("
      #include <gpgme.h>
      int main() {
        gpgme_decrypt_result_t res;
        unsigned int wku = res->wrong_key_usage;
      };"
      HAVE_GPGME_WRONG_KEY_USAGE )

  # check for GPGME_INCLUDE_CERTS_DEFAULT
  check_cxx_source_compiles("
      #include <gpgme.h>
      int main() {
        int i = GPGME_INCLUDE_CERTS_DEFAULT;
      };"
      HAVE_GPGME_INCLUDE_CERTS_DEFAULT )

  # check for gpgme_op_getauditlog
  check_cxx_source_compiles("
      #include <gpgme.h>
      int main() {
        gpgme_ctx_t ctx = 0;
        gpgme_data_t data = 0;
        unsigned int flags = 0;
        gpgme_error_t e = gpgme_op_getauditlog( ctx, data, flags );
      };"
      HAVE_GPGME_OP_GETAUDITLOG )

  # done checking for GPGME features
  tde_restore( CMAKE_CXX_FLAGS )
  tde_restore( CMAKE_REQUIRED_LIBRARIES )

endif( )


if( BUILD_KARM AND WITH_XSCREENSAVER )
  pkg_search_module( XSS xscrnsaver )

  if( XSS_FOUND )
    tde_save_and_set( CMAKE_REQUIRED_INCLUDES "${XSS_INCLUDE_DIRS}" )
    check_library_exists( Xss XScreenSaverQueryInfo "${XSS_LIBRARY_DIRS}" HAVE_XSSLIB )
    tde_restore( CMAKE_REQUIRED_INCLUDES )
  else( XSS_FOUND )
    check_library_exists( Xss XScreenSaverQueryInfo "" HAVE_XSSLIB )
  endif( XSS_FOUND )

  if( NOT HAVE_XSSLIB )
    check_library_exists( Xext XScreenSaverQueryInfo "$(XEXT_LIBRARY_DIRS}" HAVE_XSSLIB )
    if( HAVE_XSSLIB )
      pkg_search_module( XSS xext )
    endif( )
  endif( )

  check_include_file( X11/extensions/scrnsaver.h HAVE_XSCREENSAVER_H )
  if( HAVE_XSSLIB AND HAVE_XSCREENSAVER_H )
    set( HAVE_LIBXSS 1 )
  else( )
    tde_message_fatal( "xscreensaver is requested, but was not found on your system" )
  endif( )
endif( )


# required stuff
find_package( TQt )
find_package( TDE )
