/* -*- Mode: C++ -*-
   $Id$
   KDGantt - a multi-platform charting engine
*/

/****************************************************************************
 ** Copyright (C)  2002-2004 Klarlvdalens Datakonsult AB.  All rights reserved.
 **
 ** This file is part of the KDGantt library.
 **
 ** This file may be distributed and/or modified under the terms of the
 ** GNU General Public License version 2 as published by the Free Software
 ** Foundation and appearing in the file LICENSE.GPL included in the
 ** packaging of this file.
 **
 ** Licensees holding valid commercial KDGantt licenses may use this file in
 ** accordance with the KDGantt Commercial License Agreement provided with
 ** the Software.
 **
 ** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 ** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 **
 ** See http://www.klaralvdalens-datakonsult.se/Public/products/ for
 **   information about KDGantt Commercial License Agreements.
 **
 ** Contact info@klaralvdalens-datakonsult.se if any conditions of this
 ** licensing are not clear to you.
 **
 ** As a special exception, permission is given to link this program
 ** with any edition of TQt, and distribute the resulting executable,
 ** without including the source code for TQt in the source distribution.
 **
 **********************************************************************/

#ifndef KDGANTTVIEWTASKLINK_H
#define KDGANTTVIEWTASKLINK_H

#include <tqcolor.h>
#include <tqstring.h>
#include <tqptrlist.h>
#include <tqcanvas.h>

#include "KDGanttViewItem.h"
class KDGanttViewTaskLinkGroup;
class KDCanvasPolygon;
class KDCanvasLine;

class KDGanttViewTaskLink
{
public:
    enum LinkType { None, FinishStart, StartStart, FinishFinish, StartFinish };
    
    KDGanttViewTaskLink( TQPtrList<KDGanttViewItem> from,
                         TQPtrList<KDGanttViewItem> to,
                         LinkType type=None );
    KDGanttViewTaskLink( KDGanttViewTaskLinkGroup* group,
                         TQPtrList<KDGanttViewItem> from,
                         TQPtrList<KDGanttViewItem> to,
                         LinkType type=None );
    KDGanttViewTaskLink( KDGanttViewTaskLinkGroup* group,
                         KDGanttViewItem*  from,
                         KDGanttViewItem* to,
                         LinkType type=None );
    KDGanttViewTaskLink( KDGanttViewItem*  from,
                         KDGanttViewItem* to,
                         LinkType type=None );
    ~KDGanttViewTaskLink();
    TQPtrList<KDGanttViewItem> from() const;
    TQPtrList<KDGanttViewItem> to() const;
    void removeItemFromList( KDGanttViewItem* );

    void setVisible( bool );
    bool isVisible() const;

    KDGanttViewTaskLinkGroup* group();
    void setGroup( KDGanttViewTaskLinkGroup*) ;

    void setHighlight( bool highlight );
    bool highlight() const;

    void setColor( const TQColor& color );
    TQColor color() const;
    void setHighlightColor( const TQColor& color );
    TQColor highlightColor() const;

    void setTooltipText( const TQString& text );
    TQString tooltipText() const;
    void setWhatsThisText( const TQString& text );
    TQString whatsThisText() const;

    void createNode( TQDomDocument& doc,
                     TQDomElement& parentElement );
    static KDGanttViewTaskLink* createFromDomElement( TQDomElement& );

    int linkType();
    void setLinkType(int type);
    
private:
    friend class KDGanttViewTaskLinkGroup;
    friend class KDTimeTableWidget;
    TQPtrList<KDGanttViewItem> fromList,toList;
    TQPtrList<KDCanvasLine>* horLineList;
    TQPtrList<KDCanvasLine>* verLineList;
    TQPtrList<KDCanvasPolygon>* topList;

    // also used when linkType != None    
    TQPtrList<KDCanvasLine>* horLineList2;
    TQPtrList<KDCanvasLine>* verLineList2;
    TQPtrList<KDCanvasLine>* horLineList3;
    TQPtrList<KDCanvasPolygon>* topLeftList;
    TQPtrList<KDCanvasPolygon>* topRightList;
    
    KDGanttViewTaskLinkGroup* myGroup;
    bool isvisible,ishighlighted;
    TQColor myColor, myColorHL;
    TQString myToolTipText,myWhatsThisText;
    KDTimeTableWidget*  myTimeTable;
    void initTaskLink();
    void showMe( bool );
    void showMeType( bool );
    void hide();    
    int xOffset(KDGanttViewItem *item);
    
    LinkType myLinkType;
    static TQString linkTypeToString( LinkType type );
    static LinkType stringToLinkType( const TQString type );
};

#endif
