/*
   This file is part of KDE Kontact.

   Copyright (C) 2003 Sven L�ppken <sven@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef SUMMARYVIEW_PLUGIN_H
#define SUMMARYVIEW_PLUGIN_H
#include "plugin.h"

#include <tdelocale.h>
#include <tdeparts/part.h>

#include <tqmap.h>

class TDESelectAction;

class SummaryViewPart;

class SummaryView : public Kontact::Plugin
{
  Q_OBJECT
  

  public:
    SummaryView( Kontact::Core *core, const char *name, const TQStringList& );
    virtual ~SummaryView();

    int weight() const { return 100; }

    const TDEAboutData *aboutData();

  protected:
    virtual KParts::ReadOnlyPart* createPart();

  private slots:

    void doSync();
    void syncAccount( const TQString& account );
    void fillSyncActionSubEntries();

  private:
    TDEAboutData *mAboutData;
    SummaryViewPart *mPart;
    TDESelectAction *mSyncAction; 
};

#endif
