/*******************************************************************
 KNotes -- Notes for the KDE project

 Copyright (c) 2003, Daniel Martin <daniel.martin@pirack.com>
               2004, Michael Brade <brade@kde.org>

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

 In addition, as a special exception, the copyright holders give
 permission to link the code of this program with any edition of
 the TQt library by Trolltech AS, Norway (or with modified versions
 of TQt that use the same license as TQt), and distribute linked
 combinations including the two.  You must obey the GNU General
 Public License in all respects for all of the code used other than
 TQt.  If you modify this file, you may extend this exception to
 your version of the file, but you are not obligated to do so.  If
 you do not wish to do so, delete this exception statement from
 your version.
*******************************************************************/

#include <tqstring.h>
#include <tqstringlist.h>
#include <tqlabel.h>
#include <tqvbox.h>

#include <kdebug.h>
#include <tdeglobal.h>
#include <tdelocale.h>
#include <kstandarddirs.h>
#include <ksimpleconfig.h>
#include <kcombobox.h>

#include "knotehostdlg.h"
#include "knotesglobalconfig.h"


KNoteHostDlg::KNoteHostDlg( const TQString &caption, TQWidget *parent, const char *name )
    : KDialogBase( parent, name, true, caption, Ok|Cancel, Ok, true )
{
    TQVBox *page = makeVBoxMainWidget();
    (void)new TQLabel( i18n("Hostname or IP address:"), page );

    m_hostCombo = new KHistoryCombo( true, page );
    m_hostCombo->setMinimumWidth( fontMetrics().maxWidth() * 15 );
    m_hostCombo->setDuplicatesEnabled( false );

    // Read known hosts from configfile
    m_hostCombo->setHistoryItems( KNotesGlobalConfig::knownHosts(), true );
    m_hostCombo->setFocus();
    //m_hostCombo->completionObject()->setItems( KNotesGlobalConfig::hostCompletions() );
    connect( m_hostCombo->lineEdit(), TQT_SIGNAL( textChanged ( const TQString & ) ),
             this, TQT_SLOT( slotTextChanged( const TQString & ) ) );
    slotTextChanged( m_hostCombo->lineEdit()->text() );
}

KNoteHostDlg::~KNoteHostDlg()
{
    if ( result() == Accepted )
        m_hostCombo->addToHistory( m_hostCombo->currentText().stripWhiteSpace() );

    // Write known hosts to configfile
    KNotesGlobalConfig::setKnownHosts( m_hostCombo->historyItems() );
    //KNotesGlobalConfig::setHostCompletions( m_hostCombo->completionObject()->items() );
    KNotesGlobalConfig::writeConfig();
}

void KNoteHostDlg::slotTextChanged( const TQString& text )
{
    enableButtonOK( !text.isEmpty() );
}

TQString KNoteHostDlg::host() const
{
    return m_hostCombo->currentText();
}


#include "knotehostdlg.moc"
