/*
    This file is part of Kontact.
    Copyright (c) 2003 Tobias Koenig <tokoe@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

    As a special exception, permission is given to link this program
    with any edition of TQt, and distribute the resulting executable,
    without including the source code for TQt in the source distribution.
*/

#ifndef SUMMARYWIDGET_H
#define SUMMARYWIDGET_H

#include "summary.h"

#include <tqmap.h>
#include <tqptrlist.h>
#include <tqwidget.h>

#include <libkcal/resourcelocal.h>
#include <libkcal/calendarresources.h>

class TQGridLayout;
class TQLabel;

namespace Kontact {
    class Plugin;
}

class KNotesSummaryWidget : public Kontact::Summary
{
  Q_OBJECT
  

  public:
    KNotesSummaryWidget( Kontact::Plugin *plugin, TQWidget *parent, const char *name = 0 );

    void updateSummary( bool force = false ) { Q_UNUSED( force ); updateView(); }

  protected:
    virtual bool eventFilter( TQObject *obj, TQEvent* e );

  protected slots:
    void urlClicked( const TQString& );
    void updateView();
    void addNote( KCal::Journal* );
    void removeNote( KCal::Journal* );

  private:
    KCal::CalendarLocal *mCalendar;
    KCal::Journal::List mNotes;

    TQGridLayout *mLayout;

    TQPtrList<TQLabel> mLabels;
    Kontact::Plugin *mPlugin;
};

#endif
