/***************************************************************************
 *
 * tdenetman-devicestore_dbus.h - A NetworkManager frontend for TDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <Helmut.Schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef TDENETWORKMANAGER_CONNECTION_SETTING_WIRELESS_SECURITY_WIDGET_H
#define TDENETWORKMANAGER_CONNECTION_SETTING_WIRELESS_SECURITY_WIDGET_H

// tqt headers
#include <tqtimer.h>

// ui autogenerated headers
#include "connection_setting_wireless_security.h"
#include "connection_setting_wireless_security_eap.h"
#include "connection_setting_wireless_security_phase2.h"
#include "connection_setting_wireless_security_wep.h"
#include "connection_setting_wireless_security_wpaversion.h"
#include "connection_setting_wireless_security_wpacipher.h"
#include "connection_setting_wireless_security_wpapsk.h"
#include "connection_setting_wireless_security_wepencryption.h"

// tde headers
#include <tdehardwaredevices.h>
#include <tdenetworkconnections.h>

/* tdenetman headers */
#include "qbidirectionalmap.h"
#include "tdenetman-connection_settings_dialog.h"
#include "tdenetman-connection_setting_widget_interface.h"

namespace ConnectionSettings
{
	/* class declarations */
	class WirelessSecurity;
	class Wireless;
	class WirelessSecurityPhase2Impl;

	class WirelessSecurityWEPImpl : public ConnectionSettingWirelessSecurityWEP
	{
		Q_OBJECT
  
		public:
			enum WEPKEY_TYPE
			{
			  WEPKEY_TYPE_ASCII = 0
			, WEPKEY_TYPE_HEX
			, WEPKEY_TYPE_PASSPHRASE
			};

			WirelessSecurityWEPImpl(TDEWiFiConnection* security, TQWidget* parent = 0, ConnectionSettingsDialogImpl* connsettings = 0, const char* name = 0, WFlags fl = 0);
			TQCString getHashedWEPKey(TQString key, WEPKEY_TYPE type) const;
			TQCString getWEP128PassphraseHash(TQCString input) const;
			TQCString String2Hex(TQByteArray bytes, int final_len) const;

		public slots:
			void slotAuthAlgChanged(int);
			void slotKeyTypeChanged(int);
			void slotWepKey0Changed(const TQString&);
			void slotWepKey1Changed(const TQString&);
			void slotWepKey2Changed(const TQString&);
			void slotWepKey3Changed(const TQString&);
			void slotWepIdx0Checked(bool);
			void slotWepIdx1Checked(bool);
			void slotWepIdx2Checked(bool);
			void slotWepIdx3Checked(bool);

		private:
			TDEWiFiConnection* _security_setting;
			WEPKEY_TYPE _wepKeyType;

			ConnectionSettingsDialogImpl* _parentdialog;
	};

	class WirelessSecurityWEPEncryptionImpl : public ConnectionSettingWirelessSecurityWEPEncryption
	{
		Q_OBJECT
  
		public:
			WirelessSecurityWEPEncryptionImpl(TDEWiFiConnection* security_setting, TQWidget* parent = 0, ConnectionSettingsDialogImpl* connsettings = 0, const char* name = 0, WFlags fl = 0);

		private:
			TDEWiFiConnection* _security_setting;

			ConnectionSettingsDialogImpl* _parentdialog;
	};

	class WirelessSecurityWPAVersionImpl : public ConnectionSettingWirelessSecurityWPAVersion
	{
		Q_OBJECT
  
		public:
			WirelessSecurityWPAVersionImpl(TDEWiFiConnection* security_setting, TQWidget* parent = 0, ConnectionSettingsDialogImpl* connsettings = 0, const char* name = 0, WFlags fl = 0);

		public slots:
			void slotAuto(bool);
			void slotWPA1(bool);
			void slotWPA2(bool);

		private:
			TDEWiFiConnection* _security_setting;

			ConnectionSettingsDialogImpl* _parentdialog;

	};

	class WirelessSecurityWPACipherImpl : public ConnectionSettingWirelessSecurityWPACipher
	{
		Q_OBJECT
  
		private:
			enum WPA_CIPHERS
			{
				WPA_CIPHER_AUTO = 0
			, WPA_CIPHER_TKIP
			, WPA_CIPHER_CCMP
			, WPA_CIPHER_LAST
			};
		public:
			WirelessSecurityWPACipherImpl(TDEWiFiConnection* security_setting, TQWidget* parent = 0, ConnectionSettingsDialogImpl* connsettings = 0, const char* name = 0, WFlags fl = 0);

		public slots:
			void slotCipherChangedAuto(bool);
			void slotGroupCipherChangedTKIP(bool);
			void slotGroupCipherChangedCCMP(bool);
			void slotGroupCipherChangedWEP40(bool);
			void slotGroupCipherChangedWEP104(bool);
			void slotPairwiseCipherChangedTKIP(bool);
			void slotPairwiseCipherChangedCCMP(bool);

		private:
			TDEWiFiConnection* _security_setting;

			ConnectionSettingsDialogImpl* _parentdialog;
	};

	class WirelessSecurityWPAPSKImpl : public ConnectionSettingWirelessSecurityWPAPSK
	{
		Q_OBJECT
  
		public:
			WirelessSecurityWPAPSKImpl(TDEWiFiConnection* security_setting, TDEWiFiConnection* wireless_setting, TQWidget* parent = 0, ConnectionSettingsDialogImpl* connsettings = 0, const char* name = 0, WFlags fl = 0);
			TQCString String2Hex(TQByteArray bytes, int final_len) const;

		public slots:
			void slotPSKChanged(const TQString&);

		private:
			TDEWiFiConnection* _security_setting;
			TDEWiFiConnection*         _wireless_setting;

			ConnectionSettingsDialogImpl* _parentdialog;
	};

	class WirelessSecurityEAPImpl : public ConnectionSettingWirelessSecurityEAP
	{
		Q_OBJECT
  
		public:
			WirelessSecurityEAPImpl(TDEWiFiConnection* security_setting, WirelessSecurityPhase2Impl* phase2_widget, TQWidget* parent = 0, ConnectionSettingsDialogImpl* connsettings = 0, const char* name = 0, WFlags fl = 0);

		public slots:
			void slotMethodChanged(int index);
			void slotIdentityChanged(const TQString&);
			void slotAnonIdentityChanged(const TQString&);
			void slotPasswordChanged(const TQString&);
			void slotUseSystemCaCertChanged(bool on);

		private:
			TDEWiFiConnection* _security_setting;
			TQBiDirectionalMap<int, TDENetworkIEEE8021xType::TDENetworkIEEE8021xType> _eapIndexMap;
			WirelessSecurityPhase2Impl* _phase2_widget;

			ConnectionSettingsDialogImpl* _parentdialog;
	};

	class WirelessSecurityPhase2Impl : public ConnectionSettingWirelessSecurityPhase2
	{
		Q_OBJECT
  
		public:
			WirelessSecurityPhase2Impl(TDEWiFiConnection* security_setting, TQWidget* parent = 0, ConnectionSettingsDialogImpl* connsettings = 0, const char* name = 0, WFlags fl = 0);
		public slots:
			void setAllowedPhase2Methods(const TQValueList<TDENetworkIEEE8021xType::TDENetworkIEEE8021xType>&);
			void slotPhase2MethodChanged(int index);
		private:
			void updateMethodComboBox();

			TDEWiFiConnection* _security_setting;
			TQBiDirectionalMap<int, TDENetworkIEEE8021xType::TDENetworkIEEE8021xType> _eapIndexMap;
			TQValueList<TDENetworkIEEE8021xType::TDENetworkIEEE8021xType> _allowed_methods;

			ConnectionSettingsDialogImpl* _parentdialog;
	};

	class WirelessSecurityWidgetImpl : public WidgetInterface
	{
		Q_OBJECT
  
		private:
			enum SecurityMethods
			{
				SECURITY_WEP = 0
			, SECURITY_WPA_PSK
			, SECURITY_WPA_EAP
			, SECURITY_IEEE8021X
			, SECURITY_COUNT
			};

		public:
			WirelessSecurityWidgetImpl(TDENetworkConnection*, bool new_conn, TQWidget* parent = 0, const char* name = 0, WFlags fl = 0);
			void Activate();

		public slots:
			void slotComboSecurityActivated(int);
			void slotUseEncryptionToggled(bool);
			void slotExtraSettingsToggled(bool);

		private slots:
			void slotInit();

		private:
			void comboSecurityInit();
			void configureWidgets(SecurityMethods);
			void configureForWEP();
			void configureForWPAPSK();
			void configureForWPAEAP();
			void configureForIEEE8021X();

			SecurityMethods      _currentMethod;
			TQValueList<TQWidget*> _widgets[SECURITY_COUNT];
			TQValueList<TQWidget*> _extra_widgets[SECURITY_COUNT];
			TDEWiFiConnection*    _security_setting;
			TDEWiFiConnection*            _wireless_setting;
			TDEWiFiConnection*           _ieee8021x_setting;
			ConnectionSettingWirelessSecurityWidget* _mainWid;
			bool _new_conn;
			TQMap<int, SecurityMethods> _securityComboMap;

			ConnectionSettingsDialogImpl* _parentdialog;
	};
}

#endif /* TDENETWORKMANAGER_CONNECTION_SETTING_WIRELESS_SECURITY_WIDGET_H*/
