/***************************************************************************
 *
 * tdenetman.h - A NetworkManager frontend for TDE 
 *
 * Copyright (C) 2012 Timothy Pearson <kb9vqf@pearsoncomputing.net>
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Timo Hoenig       <thoenig@suse.de>, <thoenig@nouse.net>
 *         Will Stephenson   <wstephenson@suse.de>, <wstephenson@kde.org>
 *         Helmut Schaa      <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *         Alexander Naumov  <anaumov@suse.de>, <posix.ru@gmail.com> 
 * Author: Timothy Pearson <kb9vqf@pearsoncomputing.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef TDENETWORKMANAGER_TRAY_H
#define TDENETWORKMANAGER_TRAY_H

#include <tqmap.h>
#include <tqtimer.h>

#include <tqtooltip.h>
#include <ksystemtray.h>
#include <kuniqueapplication.h>
#include <tdepopupmenu.h>
#include <tdeactionclasses.h>
#include <kstdaction.h>
#include <kstdguiitem.h>

#include <tqdialog.h>
#include <tqwidget.h>

#include <tqlayout.h>
#include <tqlabel.h>
#include <tqcheckbox.h>
#include <tqprogressbar.h>
#include <tqguardedptr.h>

#include "tdenetman.h"

// #define DEBUG_STATE 1

namespace ConnectionSettings
{
	class Connection;
	class ConnectionSetting;
}

class TQMouseEvent;
class TrayComponent;
class TrayPrivate;
class TQDialog;
class TQPushButton;
class TQLabel;

class Tray : public KSystemTray
{
	Q_OBJECT
  

	public:
	  Tray ();
	  ~Tray ();
		static Tray* getInstance();
		void contextMenuAboutToShow (TDEPopupMenu* menu);
	
	signals:

	public slots:
		void slotOfflineMode();
		void slotOnlineMode();
		void slotEnableWireless();
		void slotDisableWireless();
		void slotEditConnections();

		void slotStateChanged(TDENetworkGlobalManagerFlags::TDENetworkGlobalManagerFlags newState, TDENetworkGlobalManagerFlags::TDENetworkGlobalManagerFlags prevState);
		void slotSecretsNeeded(TDENetworkConnection* connection, const TQStringList& hints, bool request_new);

		void slotDeviceAddedNotify(TDENetworkDevice*);
		void slotDeviceRemovedNotify(TDENetworkDevice*);
		void slotStateChangedNotify(TDENetworkGlobalManagerFlags::TDENetworkGlobalManagerFlags newState, TDENetworkGlobalManagerFlags::TDENetworkGlobalManagerFlags prevState);

		void slotUpdateDeviceState();
		void slotUpdateDeviceState(TDENetworkConnectionStatus::TDENetworkConnectionStatus newState, TDENetworkConnectionStatus::TDENetworkConnectionStatus prevState, TQString hwAddress);

		void slotNewVPNConnection();
		void slotVPNBannerShow(const TQString& vpnbanner);

	protected slots:
		void updateDeviceTrays();
		void slotAddDeviceTrayComponent(TQString);
		void slotRemoveDeviceTrayComponent(TQString);
		void slotDeactivateConnection(int);
		void trayComponentNeedsCenterStage(TrayComponent*, bool);
		void trayUiChanged();
		void slotEditNotifications();

	protected:
		void resizeEvent(TQResizeEvent *);

	private slots:
		void slotGenericDeviceAdded(TDEGenericDevice*);
		void slotGenericDeviceRemoved(TDEGenericDevice*);
		void slotGenericHardwareEvent(TDEHardwareEvent::TDEHardwareEvent, TQString);
		void slotVPNEventHandler(TDENetworkVPNEventType::TDENetworkVPNEventType event, TQString message);

	private:
		TQByteArray movieFileData(TQString movieName);
		TQMovie movieForName(TQString moviePath);
		TQPixmap pixmapForName(TQString pixmapPath);

		void updateGraphicsCache();

	public:
		TQMap<TQString, TQByteArray> m_movieCache;
		TQMap<TQString, TQPixmap> m_pixmapCache;

	private:
		void updateTrayIcon(TDENetworkConnectionStatus::TDENetworkConnectionStatus);
		void updateActiveConnection(TDENetworkConnectionStatus::TDENetworkConnectionStatus);
		void mousePressEvent(TQMouseEvent *e);
		void createVPNTrayComponent();
		void createDeviceTrayComponent(TQString);
		void enterEvent(TQEvent*);
		void connectTrayDeviceManager();
		void disconnectTrayDeviceManager();
		void updateTrayDeviceManagerState();
		void showActiveDeviceTray();
		void setBaseStateIcon(TDENetworkGlobalManagerFlags::TDENetworkGlobalManagerFlags nm_state);

		TrayPrivate* d;
		TDEHardwareDevices* hwdevices;
};

class NewSecretsDialog : public TQDialog
{
	Q_OBJECT
  

	public:
		NewSecretsDialog(TDENetworkConnection* connection, TQWidget * parent, const char * name, bool modal = false, TQt::WFlags f = 0);
		~NewSecretsDialog();
		void init();

	public slots:
		void slotDialogEdit();
		void reject();

	private:
		TDENetworkConnection* _connection;
};

#endif /* TDENETWORKMANAGER_TRAY_H */
