/*
    kopetestdaction.h  -  Kopete Standard Actionds

    Copyright (c) 2001-2002 by Ryan Cumming     <bodnar42@phalynx.dhs.org>
    Copyright (c) 2002-2003 by Martijn Klingens <klingens@kde.org>

    Kopete    (c) 2002-2003 by the Kopete developers  <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This library is free software; you can redistribute it and/or         *
    * modify it under the terms of the GNU Lesser General Public            *
    * License as published by the Free Software Foundation; either          *
    * version 2 of the License, or (at your option) any later version.      *
    *                                                                       *
    *************************************************************************
*/

#ifndef KOPETESTDACTION_H
#define KOPETESTDACTION_H

#undef KDE_NO_COMPAT
#include <tdeaction.h>
#include <tqobject.h>

#include "kopete_export.h"

/**
 * @author Ryan Cumming <bodnar42@phalynx.dhs.org>
 */
class KOPETE_EXPORT KopeteStdAction
{
public:
	/**
	 * Standard action to start a chat
	 */
	static TDEAction *chat( const TQObject *recvr, const char *slot,
		TQObject* parent, const char *name = 0 );
	/**
	 * Standard action to send a single message
	 */
	static TDEAction *sendMessage(const TQObject *recvr, const char *slot,
		TQObject* parent, const char *name = 0);
	/**
	 * Standard action to open a user info dialog
	 */
	static TDEAction *contactInfo(const TQObject *recvr, const char *slot,
		TQObject* parent, const char *name = 0);
	/**
	 * Standard action to open a history dialog or something similar
	 */
	static TDEAction *viewHistory(const TQObject *recvr, const char *slot,
		TQObject* parent, const char *name = 0);
	/**
	 * Standard action to initiate sending a file to a contact
	 */
	static TDEAction *sendFile(const TQObject *recvr, const char *slot,
		TQObject* parent, const char *name = 0);
	/**
	 * Standard action to change a contacts @ref Kopete::MetaContact
	 */
	static TDEAction *changeMetaContact(const TQObject *recvr, const char *slot,
		TQObject* parent, const char *name = 0);
	/**
	 * Standard action to add a group
	 */
	static TDEAction *addGroup(const TQObject *recvr, const char *slot,
		TQObject* parent, const char *name = 0);
	/**
	 * Standard action to delete a contact
	 */
	static TDEAction *deleteContact(const TQObject *recvr, const char *slot,
		TQObject* parent, const char *name = 0);
	/**
	 * Standard action to change a contact alias/nickname in your contactlist
	 */
	static TDEAction *changeAlias(const TQObject *recvr, const char *slot,
		TQObject* parent, const char *name = 0);
	/**
	 * Standard action to block a contact
	 */
	static TDEAction *blockContact(const TQObject *recvr, const char *slot,
		TQObject* parent, const char *name = 0);
	/**
	 * Standard action to unblock a contact
	 */
	static TDEAction *unblockContact(const TQObject *recvr, const char *slot,
		TQObject* parent, const char *name = 0);

	/**
	 * Return an action to change the Kopete preferences.
	 *
	 * The object has no signal/slot, the prefs are automatically shown
	 */
	static TDEAction *preferences(TDEActionCollection *parent, const char *name = 0);
};


namespace KSettings
{
	  class Dialog;
}

class KOPETE_EXPORT KopetePreferencesAction : public TDEAction
{
	  Q_OBJECT
  

	  public:
			 KopetePreferencesAction( TDEActionCollection *parent, const char *name = 0 );
			 ~KopetePreferencesAction();

	  protected slots:
			 void slotShowPreferences();
	  private:
			 static KSettings::Dialog *s_settingsDialog;
};

#endif
// vim: set noet ts=4 sts=4 sw=4:
