/*
    emoticonselector.cpp

    a button that pops up a list of all emoticons and returns
    the emoticon-string if one is selected in the list

    Copyright (c) 2002      by Stefan Gehn            <metz AT gehn.net>
    Copyright (c) 2003      by Martijn Klingens       <klingens@kde.org>

    Kopete    (c) 2002-2003 by the Kopete developers  <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#include "emoticonselector.h"
#include "kopeteemoticons.h"

#include <math.h>

#include <tqmovie.h>
#include <tqlayout.h>
#include <tqobjectlist.h>
#include <tqtooltip.h>
#include <tqobjectlist.h>

#include <kdebug.h>

EmoticonLabel::EmoticonLabel(const TQString &emoticonText, const TQString &pixmapPath, TQWidget *parent, const char *name)
	: TQLabel(parent,name)
{
	mText = emoticonText;
	setMovie( TQMovie(pixmapPath) );
	setAlignment(TQt::AlignCenter);
	TQToolTip::add(this,emoticonText);
	// Somehow TQLabel doesn't tell a reasonable size when you use setMovie
	// although it does it correctly for setPixmap. Therefore here is a little workaround
	// to tell our minimum size.
	TQPixmap p(pixmapPath);
    //
    // Some of the custom icons are rather large
    // so lets limit them to a maximum size for this display panel
    //
    if (p.width() > 32 || p.height() > 32)
        p.resize(32, 32);
	setMinimumSize(p.size());
}

void EmoticonLabel::mouseReleaseEvent(TQMouseEvent*)
{
	emit clicked(mText);
}

EmoticonSelector::EmoticonSelector(TQWidget *parent, const char *name)
	: TQWidget(parent, name)
{
//	kdDebug(14000) << k_funcinfo << "called." << endl;
	lay = 0L;
}

void EmoticonSelector::prepareList(void)
{
//	kdDebug(14000) << k_funcinfo << "called." << endl;
	int row = 0;
	int col = 0;
	TQMap<TQString, TQStringList> list = Kopete::Emoticons::self()->emoticonAndPicList();
	int emoticonsPerRow = static_cast<int>(sqrt(list.count()));
	//kdDebug(14000) << "emoticonsPerRow=" << emoticonsPerRow << endl;

	if ( lay )
	{
		TQObjectList *objList = queryList( "EmoticonLabel" );
		//kdDebug(14000) << k_funcinfo << "There are " << objList->count() << " EmoticonLabels to delete." << endl;
		objList->setAutoDelete(true);
		objList->clear();
		delete objList;
		delete lay;
	}

	lay = new TQGridLayout(this, 0, 0, 4, 4, "emoticonLayout");
	movieList.clear();
	for (TQMap<TQString, TQStringList>::const_iterator it = list.constBegin(); it != list.constEnd(); ++it )
	{
		TQWidget *w = new EmoticonLabel(it.data().first(), it.key(), this);
		movieList.push_back( ((TQLabel*)w)->movie() );
		connect(w, TQT_SIGNAL(clicked(const TQString&)), this, TQT_SLOT(emoticonClicked(const TQString&)));
//		kdDebug(14000) << "adding Emoticon to row=" << row << ", col=" << col << "." << endl;
		lay->addWidget(w, row, col);
		if ( col == emoticonsPerRow )
		{
			col = 0;
			row++;
		}
		else
			col++;
	}
	resize(minimumSizeHint());
}

void EmoticonSelector::emoticonClicked(const TQString &str)
{
//	kdDebug(14000) << "selected emoticon '" << str << "'" << endl;
	// KDE4/TQt TODO: use qobject_cast instead.
	emit ItemSelected ( str );
	if ( isVisible() && parentWidget() &&
		parentWidget()->inherits(TQPOPUPMENU_OBJECT_NAME_STRING) )
	{
		parentWidget()->close();
	}
}

void EmoticonSelector::hideEvent( TQHideEvent* )
{
	kdDebug( 14000 ) << k_funcinfo << endl;
	MovieList::iterator it;
	for( it = movieList.begin(); it != movieList.end(); ++it )
	{
		(*it)->pause();
	}
}

void EmoticonSelector::showEvent( TQShowEvent* )
{
	kdDebug( 14000 ) << k_funcinfo << endl;
	MovieList::iterator it;
	for( it = movieList.begin(); it != movieList.end(); ++it )
	{
		(*it)->unpause();
	}
}

#include "emoticonselector.moc"

// vim: set noet ts=4 sts=4 sw=4:

