#################################################
#
#  (C) 2010-2011 Serghei Amelian
#  serghei (DOT) amelian (AT) gmail.com
#
#  Improvements and feedback are welcome
#
#  This file is released under GPL >= 2
#
#################################################

check_include_file( sys/types.h HAVE_SYS_TYPES_H )
check_include_file( sys/stat.h HAVE_SYS_STAT_H )
check_include_file( sys/file.h HAVE_SYS_FILE_H )
check_include_file( unistd.h HAVE_UNISTD_H )
check_include_file( utmp.h HAVE_UTMP_H )
check_include_file( utmpx.h HAVE_UTMPX_H )

check_function_exists( vsnprintf HAVE_VSNPRINTF )

if( ${CMAKE_SYSTEM_NAME} STREQUAL "Linux" )
  set( PROC_FIND_USER 1 CACHE INTERNAL "" FORCE )
  set( UTMP_AND_PROC_FIND_USER 1 CACHE INTERNAL "" FORCE )
  set( ALL_PROCESSES_AND_PROC_FIND_USER 1 CACHE INTERNAL "" FORCE )
endif( )

check_c_source_compiles("
  #include <dirent.h>
  int select_process(const struct dirent *d) { return 0; }

  int main(int argc, char *argv[]) {
    struct dirent **namelist;
    (void) scandir(\"/proc\", &namelist, select_process, 0 /*no sort*/);
  }"
  SCANDIR_NEEDS_CONST
)
