/*
    Kopete Latex Plugin

    Copyright (c) 2004 by Duncan Mac-Vicar Prett   <duncan@kde.org>

    Kopete    (c) 2001-2004 by the Kopete developers  <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#include <tqlayout.h>
#include <tdeparts/componentfactory.h>
#include <tdelocale.h>
#include <kgenericfactory.h>
#include <kdebug.h>
#include <knuminput.h>

#include "latexplugin.h"
#include "latexconfig.h"
#include "latexprefsbase.h"
#include "latexpreferences.h"

typedef KGenericFactory<LatexPreferences> LatexPreferencesFactory;
K_EXPORT_COMPONENT_FACTORY( kcm_kopete_latex, LatexPreferencesFactory( "kcm_kopete_latex" )  )

LatexPreferences::LatexPreferences(TQWidget *parent, const char* /*name*/, const TQStringList &args)
							: TDECModule(LatexPreferencesFactory::instance(), parent, args)
{
	( new TQVBoxLayout( this ) )->setAutoAdd( true );
	m_preferencesDialog = new LatexPrefsUI(this);
	// connect widget signals here
	m_preferencesDialog->horizontalDPI->setMinValue(1);
	m_preferencesDialog->verticalDPI->setMinValue(1);
	
	connect(m_preferencesDialog->horizontalDPI, TQT_SIGNAL(valueChanged(int)), this, TQT_SLOT(slotModified()));
	connect(m_preferencesDialog->verticalDPI, TQT_SIGNAL(valueChanged(int)), this, TQT_SLOT(slotModified()));
	
	load();
}

LatexPreferences::~LatexPreferences()
{
}

void LatexPreferences::load()
{
	LatexConfig::self()->readConfig();
	// load widgets here
	m_preferencesDialog->horizontalDPI->setValue(LatexConfig::self()->horizontalDPI());
	m_preferencesDialog->verticalDPI->setValue(LatexConfig::self()->verticalDPI());
	emit TDECModule::changed(false);
}

void LatexPreferences::slotModified()
{
	emit TDECModule::changed(true);
}

void LatexPreferences::save()
{
	LatexConfig::self()->setHorizontalDPI(m_preferencesDialog->horizontalDPI->value());
	LatexConfig::self()->setVerticalDPI(m_preferencesDialog->verticalDPI->value());
	LatexConfig::self()->writeConfig();
	emit TDECModule::changed(false);
}

#include "latexpreferences.moc"

// vim: set noet ts=4 sts=4 sw=4:
