/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _DCCMANAGER_H
#define _DCCMANAGER_H

#include <time.h>

#include <tqobject.h>

#include "dccManagerbase.h"
#include "tdelistview.h"


class dccManager;
class TQSignal;
class TQObject;

class dccItem : public TQObject,
                public TDEListViewItem
{
Q_OBJECT
  
public:
    enum dccStatus {
        dccRecving,
	dccOpen,
	dccWaitOnResume,
	dccResumed,
	dccSentOffer,
	dccGotOffer,
        dccSending,
        dccDone,
        dccCancel,
        dccError
    };

    enum dccType {
        dccGet,
        dccChat,
        dccSend
    };

    dccItem( TDEListView *, dccManager *, enum dccType, const TQString &file, const TQString &who, enum dccStatus, unsigned int size );
    dccItem( TDEListViewItem *, dccManager *, enum dccType, const TQString &file, const TQString &who, enum dccStatus, unsigned int size );
    virtual ~dccItem();

    void changeStatus(enum dccStatus);
    void setReceivedBytes(int bytes);

    void setWhoPostfix(const TQString &post);
    void changeFilename(const TQString &file);
    void changeWho(const TQString &who);

    const TQString who() { return m_who; }
    const TQString file() { return m_file; }
    enum dccStatus status() { return m_status; }
    enum dccType type() { return m_type; }
    double getPercent() { return m_percent; }

    void doRename();

signals:
    void statusChanged(TQListViewItem *);
    void itemRenamed(dccItem *, TQString oldNick, TQString oldFile);

protected:
    TQString enumToStatus(enum dccStatus);

    virtual void okRename ( int col );
    virtual void cancelRename ( int col );

private:

    dccManager *m_manager;
    TQString m_who;
    TQString m_file;
    TQString m_post;
    int m_percent;
    unsigned int m_size;
    enum dccStatus m_status;
    const enum dccType m_type;
    time_t m_stime;
    time_t m_lasttime;
};


class dccNew;

class dccManager : public dccManagerbase
{
Q_OBJECT
  

public:
    dccManager( TQWidget *parent = 0, const char *name = 0 );
    ~dccManager();

    dccItem *newSendItem(TQString file, TQString who, enum dccItem::dccStatus, unsigned int size);
    dccItem *newGetItem(TQString file, TQString who, enum dccItem::dccStatus, unsigned int size);
    dccItem *newChatItem(TQString who, enum dccItem::dccStatus);

    void doChanged() { emit changed(false, TQString("dcc activity")); };

public slots:
    virtual void kpbNew_clicked();
    virtual void kpbConnect_clicked();
    virtual void kpbResume_clicked();
    virtual void kpbRename_clicked();
    virtual void kpbAbort_clicked();

signals:
    void outputLine(TQCString);
    void changed(bool, TQString);
    virtual void dccConnectClicked(dccItem *);
    virtual void dccResumeClicked(dccItem *);
    virtual void dccRenameClicked(dccItem *);
    virtual void dccAbortClicked(dccItem *);

protected slots:
    virtual void getSelChange(TQListViewItem *);
    virtual void sendSelChange(TQListViewItem *);
    virtual void dccNewAccepted(int type, TQString nick, TQString file);

private:

    TDEListViewItem *m_getit;
    TDEListViewItem *m_sendit;
    TDEListViewItem *m_chatit;

    dccNew *dccNewDialog;
};

#endif
