/*  *************************************************************************
    *   copyright: (C) 2003 Richard Lrkng <nouseforaname@home.se>         *
    *   copyright: (C) 2003 Gav Wood <gav@kde.org>                          *
    *************************************************************************
*/

/*  *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#ifndef SMSSENDPROVIDER_H
#define SMSSENDPROVIDER_H

#include <tqstring.h>
#include <tqstringlist.h>
#include <tqptrlist.h>
#include <tqlabel.h>
#include <tqvaluelist.h>

#include <klineedit.h>

#include "kopetemessage.h"

#include "smsaccount.h"

class TDEProcess;
namespace Kopete { class Account; }
class SMSContact;

class SMSSendProvider : public TQObject
{
	Q_OBJECT
  
public:
	SMSSendProvider(const TQString& providerName, const TQString& prefixValue, Kopete::Account* account, TQObject* parent = 0, const char* name = 0);
	~SMSSendProvider();

	void setAccount(Kopete::Account *account);

	int count();
	const TQString& name(int i);
	const TQString& value(int i);
	const TQString& description(int i);
	const bool isHidden(int i);

	void save(TQPtrList<KLineEdit>& args);
	void send(const Kopete::Message& msg);

	int maxSize();
private slots:
	void slotReceivedOutput(TDEProcess*, char  *buffer, int  buflen);
	void slotSendFinished(TDEProcess*);
private:
	TQStringList names;
	TQStringList descriptions;
	TQStringList values;
	TQValueList<bool> isHiddens;

	int messagePos;
	int telPos;
	int m_maxSize;

	TQString provider;
	TQString prefix;
	TQCString output;

	Kopete::Account* m_account;

	Kopete::Message m_msg;

	bool canSend;
signals:
	void messageSent(const Kopete::Message& msg);
	void messageNotSent(const Kopete::Message& msg, const TQString &error);
} ;

#endif //SMSSENDPROVIDER_H
