/*

    Copyright (C) 2001 Carsten Duvenhorst <duvenhorst@m2.uni-hannover.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

    Permission is also granted to link this program with the TQt
    library, treating TQt like a library that normally accompanies the
    operating system kernel, whether or not that is in fact the case.

*/


#ifndef KAUDIOCDCONFIG_H
#define KAUDIOCDCONFIG_H

class TDEConfigDialogManager;

#include "audiocdconfig.h"
class KAudiocdModule : public AudiocdConfig
{
  Q_OBJECT
  

public:

  KAudiocdModule(TQWidget *parent=0, const char *name=0);
  ~KAudiocdModule();

  TQString quickHelp() const;

public slots:
  void defaults();
  void save();
  void load();
  void load(bool useDefaults);
  virtual TQString handbookSection() const;
  
private slots:
  void updateExample();
  void slotConfigChanged();
  void slotEcEnable();
  void slotModuleChanged();

private:
  TDEConfig *config;
  bool configChanged;

  int getBitrateIndex(int value);

  TQPtrList<TDEConfigDialogManager> encoderSettings;
};

#endif // KAUDIOCDCONFIG_H

