/*
 * KMix -- KDE's full featured mini mixer
 *
 *
 * Copyright (C) 2004 Christian Esken <esken@kde.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <tqcursor.h>
#include <tqlabel.h>
#include <tqlayout.h>
#include <tqobject.h>
#include <tqtooltip.h>

#include <tdelocale.h>
#include <tdeconfig.h>
#include <kcombobox.h>
#include <tdeaction.h>
#include <tdepopupmenu.h>

#include <kglobalaccel.h>
#include <kkeydialog.h>

#include <kdebug.h>

#include "mdwenum.h"
#include "mixer.h"
#include "viewbase.h"

/**
 * Class that represents an Enum element (a select one-from-many selector)
 * The orientation (horizontal, vertical) is ignored
 */
MDWEnum::MDWEnum(Mixer *mixer, MixDevice* md,
                                 Qt::Orientation orientation,
                                 TQWidget* parent, ViewBase* mw, const char* name) :
    MixDeviceWidget(mixer,md,false,orientation,parent,mw,name),
     _label(0), _enumCombo(0), _layout(0)
{
    // create actions (on _mdwActions, see MixDeviceWidget)

    // KStdAction::showMenubar() is in MixDeviceWidget now
    new TDEToggleAction( i18n("&Hide"), 0, TQT_TQOBJECT(this), TQT_SLOT(setDisabled()), _mdwActions, "hide" );
    new TDEAction( i18n("C&onfigure Shortcuts..."), 0, TQT_TQOBJECT(this), TQT_SLOT(defineKeys()), _mdwActions, "keys" );

    // create widgets
    createWidgets();

    /* !!! remove this for production version */
    m_keys->insert( "Next Value", i18n( "Next Value" ), TQString(),
		    TDEShortcut(), TDEShortcut(), TQT_TQOBJECT(this), TQT_SLOT( nextEnumId() ) );

    installEventFilter( this ); // filter for popup
}

MDWEnum::~MDWEnum()
{
}


void MDWEnum::createWidgets()
{
	if ( _orientation == Qt::Vertical ) {
		_layout = new TQVBoxLayout( this );
		_layout->setAlignment(TQt::AlignHCenter);
	}
	else {
		_layout = new TQHBoxLayout( this );
		_layout->setAlignment(TQt::AlignVCenter);
	}
	TQToolTip::add( this, m_mixdevice->name() );
	
        //this->setStretchFactor( _layout, 0 );
        //TQSizePolicy qsp( TQSizePolicy::Ignored, TQSizePolicy::Maximum);
        //_layout->setSizePolicy(qsp);
        //_layout->setSpacing(KDialog::spacingHint());
        _label = new TQLabel( m_mixdevice->name(), this);
	_layout->addWidget(_label);
        _label->setFixedHeight(_label->sizeHint().height());
        _enumCombo = new KComboBox( FALSE, this, "mixerCombo" );
	// ------------ fill ComboBox start ------------
	int maxEnumId= m_mixdevice->enumValues().count();
	for (int i=0; i<maxEnumId; i++ ) {
	  _enumCombo->insertItem( *(m_mixdevice->enumValues().at(i)),i);
	}
	// ------------ fill ComboBox end --------------
	_layout->addWidget(_enumCombo);
        _enumCombo->setFixedHeight(_enumCombo->sizeHint().height());
        connect( _enumCombo, TQT_SIGNAL( activated( int ) ), TQT_TQOBJECT(this), TQT_SLOT( setEnumId( int ) ) );
        TQToolTip::add( _enumCombo, m_mixdevice->name() );
	
	//_layout->addSpacing( 4 );
}

void MDWEnum::update()
{
  if ( m_mixdevice->isEnum() ) {
    //kdDebug(67100) << "MDWEnum::update() enumID=" << m_mixdevice->enumId() << endl;
    _enumCombo->setCurrentItem( m_mixdevice->enumId() );
  }
  else {
    // !!! print warning message
  }	
}

void MDWEnum::showContextMenu()
{
    if( m_mixerwidget == NULL )
	return;

    TDEPopupMenu *menu = m_mixerwidget->getPopup();

    TQPoint pos = TQCursor::pos();
    menu->popup( pos );
}

TQSize MDWEnum::sizeHint() const {
    if ( _layout != 0 ) {
	return _layout->sizeHint();
    }
    else {
	// layout not (yet) created
	return TQWidget::sizeHint();
    }
}


/**
   This slot is called, when a user has clicked the mute button. Also it is called by any other
    associated TDEAction like the context menu.
*/
void MDWEnum::nextEnumId() {
  if( m_mixdevice->isEnum() ) {
    int curEnum = enumId();
    if ( (unsigned int)curEnum < m_mixdevice->enumValues().count() ) {
      // next enum value
      setEnumId(curEnum+1);
    }
    else {
      // wrap around
      setEnumId(0);
    }
  } // isEnum
}

void MDWEnum::setEnumId(int value)
{
	if (  m_mixdevice->isEnum() ) {
		m_mixdevice->setEnumId( value );
		m_mixer->commitVolumeChange( m_mixdevice );
	}
}

int MDWEnum::enumId()
{
	if (  m_mixdevice->isEnum() ) {
		return m_mixdevice->enumId();
	}
	else {
		return 0;
	}
}

void MDWEnum::setDisabled()
{
    setDisabled( true );
}

void MDWEnum::setDisabled( bool value ) {
    if ( m_disabled!=value)
    {
	value ? hide() : show();
	m_disabled = value;
    }
}

/**
 * An event filter for the various TQWidgets. We watch for Mouse press Events, so
 * that we can popup the context menu.
 */
bool MDWEnum::eventFilter( TQObject* obj, TQEvent* e )
{
    if (e->type() == TQEvent::MouseButtonPress) {
	TQMouseEvent *qme = TQT_TQMOUSEEVENT(e);
	if (qme->button() == Qt::RightButton) {
	    showContextMenu();
	    return true;
	}
    }
    return TQWidget::eventFilter(obj,e);
}

#include "mdwenum.moc"
