/*****************************************************************

Copyright (c) 2000-2001 the noatun authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIAB\ILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#include <tdeaboutdata.h>
#include <tdecmdlineargs.h>
#include <tdelocale.h>
#include <tqapplication.h>

#include "kaboodle_factory.h"
#include "kaboodleapp.h"

void noMessageOutput(TQtMsgType, const char *)
{
}

static TDECmdLineOptions options[] =
{
	{ "+[URL]", I18N_NOOP("URL to open"), 0 },
#ifndef NDEBUG
	{ "qdebug", I18N_NOOP("Turn on TQt Debug output"), 0 },
#endif
	TDECmdLineLastOption
};

int main(int argc, char **argv)
{
	TDECmdLineArgs::init(argc, argv, Kaboodle::KaboodleFactory::aboutData());
	TDECmdLineArgs::addCmdLineOptions(options);

#ifndef NDEBUG
	if(!TDECmdLineArgs::parsedArgs()->isSet("qdebug"))
		tqInstallMsgHandler(noMessageOutput);
#endif

	Kaboodle::KaboodleApp::addCmdLineOptions();
	Kaboodle::KaboodleApp app;

	return app.exec();
}
