
#ifndef _HTMLEXPORT_H_
#define _HTMLEXPORT_H_

#include <tqfile.h>
#include <tqtextstream.h>
#include <tqlabel.h>
#include <tqhgroupbox.h>
#include <tqlineedit.h>
#include <tqcheckbox.h>
#include <tqpushbutton.h>
#include <tqlayout.h>
#include <tqtooltip.h>
#include <tqwhatsthis.h>

#include <tdelocale.h>
#include <tdepopupmenu.h>
#include <tdefiledialog.h>
#include <tdetempfile.h>
#include <kcolorbutton.h>
#include <tdeio/netaccess.h>
#include <tdeconfig.h>
#include <kurlrequester.h>

//#include <kdebug.h>

#include <noatun/app.h>
#include <noatun/playlist.h>
#include <noatun/pref.h>
#include <noatun/plugin.h>

class TDEAction;

class HTMLExport : public TQObject, public Plugin
{
Q_OBJECT
  
NOATUNPLUGIND
public:
	HTMLExport();
	~HTMLExport();


private:
	TQString htmlEscape(const TQString &source);
	TQString getColorByEntry(TQString s);
	TDEConfig *config;
	TDEAction *mAction;

private slots:
	void slotExport();

};

class Prefs : public CModule
{
Q_OBJECT
  
public:
	Prefs(TQObject *parent);
	virtual void save();
	virtual void reopen();

	TQGroupBox* colorBox;

	KColorButton* headColorSelect;
	KColorButton* hoverColorSelect;
	KColorButton* bgColorSelect;
	KColorButton* txtColorSelect;

	TQLabel* bgColorLabel;
	TQLabel* txtColorLabel;
	TQLabel* headColorLabel;
	TQLabel* hoverColorLabel;

	TQCheckBox* linkEntries;
	TQCheckBox* numberEntries;

	TQGroupBox* bgPicBox;
	KURLRequester* bgPicPath;

protected:
	TQGridLayout* bgcolorLabel;


signals:
	void saved();
};

#endif

