/***************************************************************************
    copyright            : (C) 2003 by Arnold Krille
    email                : arnold@arnoldarts.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 ***************************************************************************/

#ifndef KRECFILEVIEWHELPERS_H
#define KRECFILEVIEWHELPERS_H

#include <tqframe.h>
#include <tqlabel.h>
#include <tqstring.h>
#include <tqpoint.h>
#include <tdeglobalsettings.h>

class TQBoxLayout;
class AKLabel;
class TQPopupMenu;
class TDEPopupMenu;

class KRecTimeBar : public TQFrame {
   Q_OBJECT
  
public:
	KRecTimeBar( TQWidget*, const char* =0 );
	~KRecTimeBar();

	void drawContents( TQPainter* );

	void mouseReleaseEvent( TQMouseEvent* );

public slots:
	void newPos( int );
	void newSize( int );
signals:
	void sNewPos( int );
private:
	int _pos, _size;
};

/**
 * Modes are:
 *  0 - Just samples
 *  1 - [hours:]mins:secs:samples
 *  2 - [hours:]mins:secs:frames ( framebase from global )
 *  3 - [hours:]mins:secs:msecs
 *
 * +100 - verbose ( [XXhours:]XXmins:XXsecs:... )
*/

class KRecTimeDisplay : public TQFrame {
   Q_OBJECT
  
public:
	KRecTimeDisplay( TQWidget*, const char* =0 );
	~KRecTimeDisplay();

	/// Resets the display to its defaultvalues
	void reset();
public slots:
	void newPos( int );
	void newSize( int );
	void newFilename( const TQString & );
	void newSamplingRate( int n ) { _samplingRate = n; }
	void newChannels( int n ) { _channels = n; }
	void newBits( int n ) { _bits = n; }
signals:
	void sNewPos( int );
private slots:
	void timeContextMenu( TQPopupMenu* );
	void timeContextMenu( const TQPoint &);
	void sizeContextMenu( TQPopupMenu* );
	void sizeContextMenu( const TQPoint &);
	void jumpToTime();
private:
	TQString positionText( int, int );
	TQString sizeText( int, int );
	TQString formatTime( const int mode, const int samples ) const;
	TQString _filename;
	TQBoxLayout *_layout;
	AKLabel *_position, *_size;
	TDEPopupMenu *_posmenu, *_sizemenu;
	int _sizevalue, _posvalue;
	int _samplingRate, _bits, _channels;
};


class AKLabel : public TQLabel {
  Q_OBJECT
  
public:
	AKLabel( TQWidget* p, const char* n=0, WFlags f=0 ) : TQLabel( p, n, f ) { init(); }
	AKLabel( const TQString& s, TQWidget* p, const char* n=0, WFlags f=0 ) : TQLabel( s, p, n, f ) { init(); }
	AKLabel( TQWidget* w, const TQString& s, TQWidget* p, const char* n=0, WFlags f=0 ) : TQLabel( w,s,p,n,f ) { init(); }

	void mousePressEvent( TQMouseEvent* );
signals:
	void showContextMenu( const TQPoint & );
private:
	void init() {
		setFont( TDEGlobalSettings::fixedFont() );
	}
};
#endif

// vim:sw=4:ts=4
