    /*

    Copyright (  C ) 2002, 2003 Arnold Krille <arnold@arnoldarts.de>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (  at your option ) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.

    */

#include "tdepopupbox_impl.h"
#include "tdepopupbox_private.h"

#include <tqlayout.h>

using namespace Arts;

TDEPopupBox_impl::TDEPopupBox_impl( TDEPopupBox_widget *w ) : KFrame_impl( w ? w : new TDEPopupBox_widget )
{
	self().framestyle( Box ); self().margin( 1 ); self().linewidth( 1 );
	self().vSizePolicy( spFixed ); self().hSizePolicy( spFixed );

	if( !w ) w = static_cast<TDEPopupBox_widget *>( _qframe );

	_widget = w;
//	_mapper = new TDEPopupBoxEventMapper( _widget, this );
}
TDEPopupBox_impl::~TDEPopupBox_impl() {
}

Direction TDEPopupBox_impl::direction() { return _widget->direction(); }
void TDEPopupBox_impl::direction( Direction n ) { _widget->direction( n ); }

void TDEPopupBox_impl::widget( Arts::Widget widget ) {
	widget.parent( self() );
	this->_addChild( widget, "PopupBox_child" );
	_widget->setWidget( widget );
}
Arts::Widget TDEPopupBox_impl::widget() { return _widget->getWidget(); }

std::string TDEPopupBox_impl::name() { return _name; }
void TDEPopupBox_impl::name( const std::string& n ) { _name = ""; _name = n; _widget->name( n ); }

// Following the private class:

TDEPopupBox_widget::TDEPopupBox_widget( TQWidget *parent, const char* name ) : TQFrame( parent,name )
{
	this->setFrameShape( TQFrame::Box );
	this->setMargin( 1 ); this->setLineWidth( 1 );

	_titlebar = new TQFrame( this );
	_titlebarlayout = new TQBoxLayout( _titlebar, TQBoxLayout::BottomToTop );
	_titlebarlayout->setAutoAdd( true );

	_showbutton = new ShowButton( _titlebar );
	connect( _showbutton, TQT_SIGNAL( toggled( bool ) ), this, TQT_SLOT( hide( bool ) ) );
	_drag = new HandleDrag( _titlebar );
	connect( _drag, TQT_SIGNAL( clicked() ), _showbutton, TQT_SLOT( toggle() ) );
	_ownbutton = new OwnButton( _titlebar );
	connect( _ownbutton, TQT_SIGNAL( toggled( bool ) ), this, TQT_SLOT( own( bool ) ) );

	_artswidget = new OwnWidget( _showbutton, this );

	_layout = new TQBoxLayout( this, TQBoxLayout::LeftToRight );
	_layout->addWidget( _titlebar , -1 );
	_layout->addWidget( _artswidget, 20 );
	_layout->addStretch( 0 );
}
TDEPopupBox_widget::~TDEPopupBox_widget() {
}

Arts::Direction TDEPopupBox_widget::direction() {
	return Arts::Direction( _layout->direction() );
}

void TDEPopupBox_widget::direction( Arts::Direction n ) {
	_layout->setDirection( TQBoxLayout::Direction( n ) );
	_showbutton->direction( TQBoxLayout::Direction( n ) );
	switch( n ) {
		case LeftToRight:
		case RightToLeft:
			_titlebarlayout->setDirection( TQBoxLayout::BottomToTop );
			_drag->setMinimumHeight( 30 );
			_drag->setMinimumWidth( 0 );
			break;
		case TopToBottom:
		case BottomToTop:
			_titlebarlayout->setDirection( TQBoxLayout::RightToLeft );
			_drag->setMinimumHeight( 0 );
			_drag->setMinimumWidth( 30 );
	}
}

void TDEPopupBox_widget::setWidget( Arts::Widget widget ) { _artswidget->setContent( widget ); }
Arts::Widget TDEPopupBox_widget::getWidget() { return _artswidget->content(); }

void TDEPopupBox_widget::hide( bool n ) {
	if( n )
		_artswidget->hide();
	else
		_artswidget->show();
}

void TDEPopupBox_widget::own( bool n ) {
	if ( n )
		_artswidget->reparent( 0, _artswidget->mapToGlobal( _artswidget->pos() ), !( _artswidget->isHidden() ) );
	else
	{
		_artswidget->reparent( this, TQPoint( 0,0 ), !( _artswidget->isHidden() ) );
		_layout->insertWidget( 1, _artswidget, 20 );
	}
}

void TDEPopupBox_widget::name( std::string n ) {
	_artswidget->setCaption( n.c_str() );
}

REGISTER_IMPLEMENTATION( TDEPopupBox_impl );

#include "tdepopupbox_private.moc"

// vim: sw=4 ts=4

