/*
 * KMix -- KDE's full featured mini mixer
 *
 *
 * Copyright (C) 2000 Stefan Schimanski <1Stein@gmx.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <tqsizepolicy.h>

#include "kledbutton.h"


KLedButton::KLedButton(const TQColor &col, TQWidget *parent, const char *name)
   : KLed( col, parent, name )
{	
    // KLed and thus KLedButtung does not do proper positioning in TQLayout's.
    // Thus I will do a dirty trick here
    installEventFilter(parent);
}

KLedButton::KLedButton(const TQColor& col, KLed::State st, KLed::Look look,
		       KLed::Shape shape, TQWidget *parent, const char *name)
   : KLed( col, st, look, shape, parent, name )
{
}

KLedButton::~KLedButton()
{
}

void KLedButton::mousePressEvent( TQMouseEvent *e )
{
   if (e->button() == Qt::LeftButton)
   {
      toggle();
      emit stateChanged( state() );
   }
}

bool KLedButton::eventFilter( TQObject* /*obj*/ , TQEvent* /*ev*/ ) {
    // KLed and thus KLedButtung does not do proper positioning in TQLayout's.
    // Thus I listen to my parents resize events and do it here ... OUCH, that's ugly
    /* No, this cannot work !
    if ( ev->type() == TQEvent::Resize ) {
	TQResizeEvent* qre = (TQResizeEvent*)ev;
	this->move( qre->size().width()  - width()/2,
		    qre->size().height() - height()/2 );
    }
    */
    return false;
    //    KLed::eventFilter(obj, ev);

}	

TQSize KLedButton::sizeHint() const
{
    return size();
}

TQSizePolicy KLedButton::sizePolicy () const
{
    return TQSizePolicy(TQSizePolicy::Fixed, TQSizePolicy::Fixed);
}

#include "kledbutton.moc"
