#ifndef EQUALIZERVIEW_H
#define EQUALIZERVIEW_H

#include <tqwidget.h>
#include <kdialogbase.h>
#include <tdelistview.h>

class VBand;
class TQSlider;
class TQLabel;
class TQListViewItem;
class VPreset;
class TQHBoxLayout;
class EqualizerWidget;


class EqualizerLevel : public TQWidget
{
Q_OBJECT
  
public:
	EqualizerLevel(TQWidget *parent, VBand band);

public slots:
	void changed();
	void changed(int);

	void setBand(VBand band);

private:
	VBand mBand;
	TQSlider *mSlider;
	TQLabel *mLabel;
};


class PresetList : public TDEListView
{
Q_OBJECT
  
public:
	PresetList(TQWidget *parent, const char *name=0);

public:
	void rename(TQListViewItem *item, int c);
};


class EqualizerView : public KDialogBase
{
Q_OBJECT
  
	TQPtrList<EqualizerLevel> mBands;

public:
	EqualizerView();
	virtual void show();

	TQListViewItem *itemFor(const TQString &filename);
	TQListViewItem *itemFor(const VPreset &preset);

public slots:
	void setPreamp(int);
	void changedPreamp(int);

private slots:
	void changedBands();
	void changedEq();

	void removed(VPreset p);
	void created(VPreset p);
	void renamed(VPreset p);

	void remove();
	void create();
	void reset();
	void rename(TQListViewItem *);
	void select(TQListViewItem*);

private:
	bool first;
	EqualizerWidget *mWidget;
	TQHBoxLayout *bandsLayout;
// 	TQCheckBox *mOn;
// 	TQSlider *mPreamp;
	PresetList *mPresets;
	bool mGoingPreset;
// 	TQPushButton *mRemovePreset, *mAddPreset;
// 	TQFrame *mSliders;
// 	KIntNumInput *mBandCount;
};

#endif

