/***************************************************************************
    copyright            : (C) 2003 by Arnold Krille
    email                : arnold@arnoldarts.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 ***************************************************************************/

#ifndef KREC_CONFIGURE_H
#define KREC_CONFIGURE_H

#include <tdecmodule.h>
#include <tqstringlist.h>
#include <tqstring.h>

class TQBoxLayout;
class TQRadioButton;
class TQButtonGroup;
class TQLineEdit;
class TQHBox;
class TQLabel;
class TQCheckBox;
class KPushButton;

class KRecConfigGeneral : public TDECModule {
   Q_OBJECT
  
public:
	KRecConfigGeneral( TQWidget*, const char* =0, const TQStringList& = TQStringList() );
	~KRecConfigGeneral();

	void load();
	void save();
	void defaults();
private slots:

	void displaychanged( int );
	void framebasechanged( int );
	void framebaseotherchanged( const TQString& );
	void verboseDisplayChanged( bool );

	void tipofdaychanged( bool );
	void enableallmessagesclicked();
private:
	TQBoxLayout *_layout, *_layout_display;
	TQLabel *_display_title, *_other_title;
	TQButtonGroup *_displaybox, *_framebasebox;
	TQRadioButton *_display0, *_display1, *_display2, *_display3;
	TQRadioButton *_framebase30, *_framebase25, *_framebase75, *_framebaseother;
	TQHBox *_framebaseotherbox;
	TQLabel *_framebaseotherlabel;
	TQLineEdit *_framebaseotherline;

	TQCheckBox *_tipofday, *_verboseDisplayMode;
	KPushButton *_enableAllMessages;

	int _displaymode, _framebase;
	bool _tip;
};

#endif
