// Copyright (c) 2002-2004 Rob Kaper <cap@capsi.com>
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// version 2 as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.

#ifndef ATLANTIK_SELECTSERVER_WIDGET_H
#define ATLANTIK_SELECTSERVER_WIDGET_H

#include <tqwidget.h>
#include <tqlayout.h>
#include <tqradiobutton.h>

#include <klineedit.h>
#include <tdelistview.h>
#include <kpushbutton.h>

#include "monopigator.h"

class KExtendedSocket;

class SelectServer : public TQWidget
{
Q_OBJECT
  

public:
	SelectServer(bool useMonopigatorOnStart, bool hideDevelopmentServers, TQWidget *parent, const char *name=0);
	virtual ~SelectServer();

	void initPage();
	void setHideDevelopmentServers(bool hideDevelopmentServers);
	bool validateNext();
	TQString hostToConnect() const;
	int portToConnect();

public slots:
	void validateConnectButton();
	void slotRefresh(bool useMonopigator = true);
	void slotMonopigatorAdd(TQString ip, TQString host, TQString port, TQString version, int users);

private slots:
	void slotConnect();
	void customConnect();
	void monopigatorFinished();
	void monopigatorTimeout();

signals:
	void serverConnect(const TQString host, int port);
	void msgStatus(const TQString &message);
	void showDevelopmentServers(bool show);

private:
	void initMonopigator();

	TQVBoxLayout *m_mainLayout;
	TDEListView *m_serverList;
	KLineEdit *m_hostEdit, *m_portEdit;
	KPushButton *m_addServerButton, *m_refreshButton, *m_customConnect, *m_connectButton;
	Monopigator *m_monopigator;
	bool m_hideDevelopmentServers;
};

#endif
