


#include <tqcstring.h>
#include <tqimage.h>
#include <tqpainter.h>
#include <tqpalette.h>
#include <tqpixmap.h>
#include <tqfont.h>

#include <kjs/object.h>

#include <kjsembed/global.h>
#include <kjsembed/jsobjectproxy.h>
#include <kjsembed/jsopaqueproxy.h>
#include <kjsembed/jsbinding.h>

#include <tqcanvas.h>
#include "qcanvaspixmaparray_imp.h"

/**
 * Namespace containing the KJSEmbed library.
 */
namespace KJSEmbed {

TQCanvasPixmapArrayImp::TQCanvasPixmapArrayImp( KJS::ExecState *exec, int mid, bool constructor )
   : JSProxyImp(exec), id(mid), cons(constructor)
{
}

TQCanvasPixmapArrayImp::~TQCanvasPixmapArrayImp()
{
}

/**
 * Adds bindings for static methods and enum constants to the specified Object.
 */
void TQCanvasPixmapArrayImp::addStaticBindings( KJS::ExecState *exec, KJS::Object &object )
{
    JSProxy::MethodTable methods[] = {

	{ 0, 0 }
    };

    int idx = 0;
    TQCString lastName;

    while( methods[idx].name ) {
        if ( lastName != methods[idx].name ) {
            TQCanvasPixmapArrayImp *meth = new TQCanvasPixmapArrayImp( exec, methods[idx].id );
            object.put( exec , methods[idx].name, KJS::Object(meth) );
            lastName = methods[idx].name;
        }
        ++idx;
    }


}

/**
 * Adds bindings for instance methods to the specified Object.
 */
void TQCanvasPixmapArrayImp::addBindings( KJS::ExecState *exec, KJS::Object &object )
{
    JSProxy::MethodTable methods[] = {

        { Method_readPixmaps_6, "readPixmaps" },
        { Method_readCollisionMasks_7, "readCollisionMasks" },
        { Method_isValid_9, "isValid" },
        { Method_image_10, "image" },
        { Method_setImage_11, "setImage" },
        { Method_count_12, "count" },
	{ 0, 0 }
    };

    int idx = 0;
    TQCString lastName;

    while( methods[idx].name ) {
        if ( lastName != methods[idx].name ) {
            TQCanvasPixmapArrayImp *meth = new TQCanvasPixmapArrayImp( exec, methods[idx].id );
            object.put( exec , methods[idx].name, KJS::Object(meth) );
            lastName = methods[idx].name;
        }
        ++idx;
    }
}

/**
 * Extract a TQCanvasPixmapArray pointer from an Object.
 */
TQCanvasPixmapArray *TQCanvasPixmapArrayImp::toTQCanvasPixmapArray( KJS::Object &self )
{
    JSObjectProxy *ob = JSProxy::toObjectProxy( self.imp() );
    if ( ob ) {
        TQObject *obj = ob->object();
	if ( obj )
           return dynamic_cast<TQCanvasPixmapArray *>( obj );
    }

    JSOpaqueProxy *op = JSProxy::toOpaqueProxy( self.imp() );
    if ( !op )
        return 0;

    if ( op->typeName() != "TQCanvasPixmapArray" )
        return 0;

    return op->toNative<TQCanvasPixmapArray>();
}

/**
 * Select and invoke the correct constructor.
 */
KJS::Object TQCanvasPixmapArrayImp::construct( KJS::ExecState *exec, const KJS::List &args )
{
   switch( id ) {

         case Constructor_QCanvasPixmapArray_1:
             return TQCanvasPixmapArray_1( exec, args );
             break;

         case Constructor_QCanvasPixmapArray_2:
             return TQCanvasPixmapArray_2( exec, args );
             break;

         case Constructor_QCanvasPixmapArray_3:
             return TQCanvasPixmapArray_3( exec, args );
             break;

         case Constructor_QCanvasPixmapArray_4:
             return TQCanvasPixmapArray_4( exec, args );
             break;

         default:
             break;
    }

    TQString msg = i18n("TQCanvasPixmapArrayCons has no constructor with id '%1'.").arg(id);
    return throwError(exec, msg,KJS::ReferenceError);
}


KJS::Object TQCanvasPixmapArrayImp::TQCanvasPixmapArray_1( KJS::ExecState *exec, const KJS::List &args )
{


    // We should now create an instance of the TQCanvasPixmapArray object

    TQCanvasPixmapArray *ret = new TQCanvasPixmapArray(
        );

	return KJS::Object();
}

KJS::Object TQCanvasPixmapArrayImp::TQCanvasPixmapArray_2( KJS::ExecState *exec, const KJS::List &args )
{

    TQString arg0 = extractTQString(exec, args, 0);

    int arg1 = extractInt(exec, args, 1);


    // We should now create an instance of the TQCanvasPixmapArray object

    TQCanvasPixmapArray *ret = new TQCanvasPixmapArray(

          arg0,
          arg1 );
	return KJS::Object();

}

KJS::Object TQCanvasPixmapArrayImp::TQCanvasPixmapArray_3( KJS::ExecState *exec, const KJS::List &args )
{

    // Unsupported parameter TQPtrList< TQPixmap >
    return KJS::Object();

    TQPtrList< TQPixmap > arg0; // Dummy

    // Unsupported parameter TQPtrList< TQPoint >
    return KJS::Object();

    TQPtrList< TQPoint > arg1; // Dummy


    // We should now create an instance of the TQCanvasPixmapArray object

    TQCanvasPixmapArray *ret = new TQCanvasPixmapArray(

          arg0,
          arg1 );


}

KJS::Object TQCanvasPixmapArrayImp::TQCanvasPixmapArray_4( KJS::ExecState *exec, const KJS::List &args )
{

    // Unsupported parameter TQValueList< TQPixmap >
    return KJS::Object();

    TQValueList< TQPixmap > arg0; // Dummy

    // Unsupported parameter TQPointArray
    return KJS::Object();

    TQPointArray arg1; // Dummy


    // We should now create an instance of the TQCanvasPixmapArray object

    TQCanvasPixmapArray *ret = new TQCanvasPixmapArray(

          arg0,
          arg1 );


}

KJS::Value TQCanvasPixmapArrayImp::call( KJS::ExecState *exec, KJS::Object &self, const KJS::List &args )
{
    instance = TQCanvasPixmapArrayImp::toTQCanvasPixmapArray( self );

    switch( id ) {

    case Method_readPixmaps_6:
        return readPixmaps_6( exec, self, args );
        break;

    case Method_readCollisionMasks_7:
        return readCollisionMasks_7( exec, self, args );
        break;

    case Method_isValid_9:
        return isValid_9( exec, self, args );
        break;

    case Method_image_10:
        return image_10( exec, self, args );
        break;

    case Method_setImage_11:
        return setImage_11( exec, self, args );
        break;

    case Method_count_12:
        return count_12( exec, self, args );
        break;

    default:
        break;
    }

    TQString msg = i18n( "TQCanvasPixmapArrayImp has no method with id '%1'." ).arg( id );
    return throwError(exec, msg,KJS::ReferenceError);
}


KJS::Value TQCanvasPixmapArrayImp::readPixmaps_6( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    TQString arg0 = extractTQString(exec, args, 0);

    int arg1 = extractInt(exec, args, 1);

      bool ret;
      ret = instance->readPixmaps(
       arg0,
       arg1 );
      return KJS::Boolean( ret );

}

KJS::Value TQCanvasPixmapArrayImp::readCollisionMasks_7( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    TQString arg0 = extractTQString(exec, args, 0);

      bool ret;
      ret = instance->readCollisionMasks(
       arg0 );
      return KJS::Boolean( ret );

}

KJS::Value TQCanvasPixmapArrayImp::isValid_9( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      bool ret;
      ret = instance->isValid(  );
      return KJS::Boolean( ret );

}

KJS::Value TQCanvasPixmapArrayImp::image_10( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    int arg0 = extractInt(exec, args, 0);

      instance->image(
       arg0 );
      return KJS::Value(); // Returns 'TQCanvasPixmap *'

}

KJS::Value TQCanvasPixmapArrayImp::setImage_11( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    int arg0 = extractInt(exec, args, 0);

    // Unsupported parameter TQCanvasPixmap *
    return KJS::Value();

    TQCanvasPixmap * arg1; // Dummy

      instance->setImage(
       arg0,
       arg1 );
      return KJS::Value(); // Returns void

}

KJS::Value TQCanvasPixmapArrayImp::count_12( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      uint ret;
      ret = instance->count(  );
      return KJS::Number( ret );

}


} // namespace KJSEmbed

// Local Variables:
// c-basic-offset: 4
// End:


