


#include <tqcstring.h>
#include <tqimage.h>
#include <tqpainter.h>
#include <tqpalette.h>
#include <tqpixmap.h>
#include <tqfont.h>

#include <kjs/object.h>

#include <kjsembed/global.h>
#include <kjsembed/jsobjectproxy.h>
#include <kjsembed/jsopaqueproxy.h>
#include <kjsembed/jsbinding.h>

#include <tqpopupmenu.h>
#include "qpopupmenu_imp.h"

/**
 * Namespace containing the KJSEmbed library.
 */
namespace KJSEmbed {

TQPopupMenuImp::TQPopupMenuImp( KJS::ExecState *exec, int mid, bool constructor )
   : JSProxyImp(exec), id(mid), cons(constructor)
{
}

TQPopupMenuImp::~TQPopupMenuImp()
{
}

/**
 * Adds bindings for static methods and enum constants to the specified Object.
 */
void TQPopupMenuImp::addStaticBindings( KJS::ExecState *exec, KJS::Object &object )
{
    JSProxy::MethodTable methods[] = {

	{ 0, 0 }
    };

    int idx = 0;
    TQCString lastName;

    while( methods[idx].name ) {
        if ( lastName != methods[idx].name ) {
            TQPopupMenuImp *meth = new TQPopupMenuImp( exec, methods[idx].id );
            object.put( exec , methods[idx].name, KJS::Object(meth) );
            lastName = methods[idx].name;
        }
        ++idx;
    }


}

/**
 * Adds bindings for instance methods to the specified Object.
 */
void TQPopupMenuImp::addBindings( KJS::ExecState *exec, KJS::Object &object )
{
    JSProxy::MethodTable methods[] = {

        { Method_popup_3, "popup" },
        { Method_updateItem_4, "updateItem" },
        { Method_setCheckable_5, "setCheckable" },
        { Method_isCheckable_6, "isCheckable" },
        { Method_setFont_7, "setFont" },
        { Method_show_8, "show" },
        { Method_hide_9, "hide" },
        { Method_exec_10, "exec" },
        { Method_exec_11, "exec" },
        { Method_setActiveItem_12, "setActiveItem" },
        { Method_sizeHint_13, "sizeHint" },
        { Method_idAt_14, "idAt" },
        { Method_idAt_15, "idAt" },
        { Method_customWhatsThis_16, "customWhatsThis" },
        { Method_insertTearOffHandle_17, "insertTearOffHandle" },
        { Method_activateItemAt_18, "activateItemAt" },
        { Method_itemGeometry_19, "itemGeometry" },
	{ 0, 0 }
    };

    int idx = 0;
    TQCString lastName;

    while( methods[idx].name ) {
        if ( lastName != methods[idx].name ) {
            TQPopupMenuImp *meth = new TQPopupMenuImp( exec, methods[idx].id );
            object.put( exec , methods[idx].name, KJS::Object(meth) );
            lastName = methods[idx].name;
        }
        ++idx;
    }
}

/**
 * Extract a TQPopupMenu pointer from an Object.
 */
TQPopupMenu *TQPopupMenuImp::toTQPopupMenu( KJS::Object &self )
{
    JSObjectProxy *ob = JSProxy::toObjectProxy( self.imp() );
    if ( ob ) {
        TQObject *obj = ob->object();
	if ( obj )
           return dynamic_cast<TQPopupMenu *>( obj );
    }

    JSOpaqueProxy *op = JSProxy::toOpaqueProxy( self.imp() );
    if ( !op )
        return 0;

    if ( op->typeName() != "TQPopupMenu" )
        return 0;

    return op->toNative<TQPopupMenu>();
}

/**
 * Select and invoke the correct constructor.
 */
KJS::Object TQPopupMenuImp::construct( KJS::ExecState *exec, const KJS::List &args )
{
   switch( id ) {

         case Constructor_QPopupMenu_1:
             return TQPopupMenu_1( exec, args );
             break;

         default:
             break;
    }

    TQString msg = i18n("TQPopupMenuCons has no constructor with id '%1'").arg(id);
    return throwError(exec, msg,KJS::ReferenceError);
}


KJS::Object TQPopupMenuImp::TQPopupMenu_1( KJS::ExecState *exec, const KJS::List &args )
{

    // Unsupported parameter TQWidget *
    return KJS::Object();

    TQWidget * arg0; // Dummy

    const char *arg1 = (args.size() >= 2) ? args[1].toString(exec).ascii() : 0;


    // We should now create an instance of the TQPopupMenu object

    TQPopupMenu *ret = new TQPopupMenu(

          arg0,
          arg1 );


}

KJS::Value TQPopupMenuImp::call( KJS::ExecState *exec, KJS::Object &self, const KJS::List &args )
{
    instance = TQPopupMenuImp::toTQPopupMenu( self );

    switch( id ) {

    case Method_popup_3:
        return popup_3( exec, self, args );
        break;

    case Method_updateItem_4:
        return updateItem_4( exec, self, args );
        break;

    case Method_setCheckable_5:
        return setCheckable_5( exec, self, args );
        break;

    case Method_isCheckable_6:
        return isCheckable_6( exec, self, args );
        break;

    case Method_setFont_7:
        return setFont_7( exec, self, args );
        break;

    case Method_show_8:
        return show_8( exec, self, args );
        break;

    case Method_hide_9:
        return hide_9( exec, self, args );
        break;

    case Method_exec_10:
        return exec_10( exec, self, args );
        break;

    case Method_exec_11:
        return exec_11( exec, self, args );
        break;

    case Method_setActiveItem_12:
        return setActiveItem_12( exec, self, args );
        break;

    case Method_sizeHint_13:
        return sizeHint_13( exec, self, args );
        break;

    case Method_idAt_14:
        return idAt_14( exec, self, args );
        break;

    case Method_idAt_15:
        return idAt_15( exec, self, args );
        break;

    case Method_customWhatsThis_16:
        return customWhatsThis_16( exec, self, args );
        break;

    case Method_insertTearOffHandle_17:
        return insertTearOffHandle_17( exec, self, args );
        break;

    case Method_activateItemAt_18:
        return activateItemAt_18( exec, self, args );
        break;

    case Method_itemGeometry_19:
        return itemGeometry_19( exec, self, args );
        break;

    default:
        break;
    }

    TQString msg = i18n( "TQPopupMenuImp has no method with id '%1'" ).arg( id );
    return throwError(exec, msg,KJS::ReferenceError);
}


KJS::Value TQPopupMenuImp::popup_3( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    TQPoint arg0 = extractTQPoint(exec, args, 0);

    int arg1 = extractInt(exec, args, 1);

      instance->popup(
       arg0,
       arg1 );
      return KJS::Value(); // Returns void

}

KJS::Value TQPopupMenuImp::updateItem_4( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    int arg0 = extractInt(exec, args, 0);

      instance->updateItem(
       arg0 );
      return KJS::Value(); // Returns void

}

KJS::Value TQPopupMenuImp::setCheckable_5( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    bool arg0 = extractBool(exec, args, 0);

      instance->setCheckable(
       arg0 );
      return KJS::Value(); // Returns void

}

KJS::Value TQPopupMenuImp::isCheckable_6( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      bool ret;
      ret = instance->isCheckable(  );
      return KJS::Boolean( ret );

}

KJS::Value TQPopupMenuImp::setFont_7( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    TQFont arg0 = extractTQFont(exec, args, 0);

      instance->setFont(
       arg0 );
      return KJS::Value(); // Returns void

}

KJS::Value TQPopupMenuImp::show_8( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      instance->show(  );
      return KJS::Value(); // Returns void

}

KJS::Value TQPopupMenuImp::hide_9( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      instance->hide(  );
      return KJS::Value(); // Returns void

}

KJS::Value TQPopupMenuImp::exec_10( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      int ret;
      ret = instance->exec(  );
      return KJS::Number( ret );

}

KJS::Value TQPopupMenuImp::exec_11( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    TQPoint arg0 = extractTQPoint(exec, args, 0);

    int arg1 = extractInt(exec, args, 1);

      int ret;
      ret = instance->exec(
       arg0,
       arg1 );
      return KJS::Number( ret );

}

KJS::Value TQPopupMenuImp::setActiveItem_12( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    int arg0 = extractInt(exec, args, 0);

      instance->setActiveItem(
       arg0 );
      return KJS::Value(); // Returns void

}

KJS::Value TQPopupMenuImp::sizeHint_13( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    TQSize ret;
      ret = instance->sizeHint(  );

       return convertToValue( exec, ret );

}

KJS::Value TQPopupMenuImp::idAt_14( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    int arg0 = extractInt(exec, args, 0);

      int ret;
      ret = instance->idAt(
       arg0 );
      return KJS::Number( ret );

}

KJS::Value TQPopupMenuImp::idAt_15( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    TQPoint arg0 = extractTQPoint(exec, args, 0);

      int ret;
      ret = instance->idAt(
       arg0 );
      return KJS::Number( ret );

}

KJS::Value TQPopupMenuImp::customWhatsThis_16( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      bool ret;
      ret = instance->customWhatsThis(  );
      return KJS::Boolean( ret );

}

KJS::Value TQPopupMenuImp::insertTearOffHandle_17( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    int arg0 = extractInt(exec, args, 0);

    int arg1 = extractInt(exec, args, 1);

      int ret;
      ret = instance->insertTearOffHandle(
       arg0,
       arg1 );
      return KJS::Number( ret );

}

KJS::Value TQPopupMenuImp::activateItemAt_18( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    int arg0 = extractInt(exec, args, 0);

      instance->activateItemAt(
       arg0 );
      return KJS::Value(); // Returns void

}

KJS::Value TQPopupMenuImp::itemGeometry_19( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    int arg0 = extractInt(exec, args, 0);
        TQRect ret;
      ret = instance->itemGeometry(
       arg0 );

       return convertToValue( exec, ret );

}


} // namespace KJSEmbed

// Local Variables:
// c-basic-offset: 4
// End:


