// -*- c++ -*-

/*
 *  Copyright (C) 2003, Ian Reinhart Geiser <geiseri@kde.org>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 */

#ifndef KJSEMBED_CONFIG_IMP_H
#define KJSEMBED_CONFIG_IMP_H

#include <tqdatetime.h>
#include <tqfont.h>
#include <tqvariant.h>
#include <tqpoint.h>
#include <tqrect.h>
#include <tqsize.h>
#include <tqcolor.h>
#include <tqstringlist.h>

#include "bindingobject.h"

#ifndef QT_ONLY
class TDEConfig;
#else
class TQSettings;
#endif

namespace KJSEmbed {
namespace Bindings {

class Config : public BindingObject
{
    Q_OBJECT
    TQ_PROPERTY( bool forceGlobal READ forceGlobal WRITE setForceGlobal )
    TQ_PROPERTY( bool dollarExpansion READ isDollarExpansion WRITE setDollarExpansion )
    TQ_PROPERTY( bool readOnly READ isReadOnly WRITE setReadOnly )
    TQ_PROPERTY( bool readDefaults READ readDefaults WRITE setReadDefaults )

public:
    Config( TQObject *parent=0, const char *name=0);
    /*
    Config( TQObject *parent, const char *name,  const TQString& confName );
    */
    virtual ~Config();

    void setForceGlobal( bool force );
    bool forceGlobal() const;
    void setDollarExpansion( bool _bExpand  );
    bool isDollarExpansion() const;
    void setReadOnly(bool _ro);
    bool isReadOnly() const;
    void setReadDefaults(bool b);
    bool readDefaults() const;

public slots:

	// Group
    void setDesktopGroup();
    void setGroup(const TQString&);
    TQString group();
    TQStringList groupList();
    TQString locale();

    void rollback( bool bDeep  );
    void sync();
    bool hasKey( const TQString& key ) const;
    bool entryIsImmutable(const TQString &key) const;
    void revertToDefault(const TQString &key);
    bool hasDefault(const TQString &key) const;

    void setFileWriteMode(int mode);
    TQString readEntry(const TQString& pKey, const TQString& aDefault ) const;
    TQVariant readPropertyEntry( const TQString& pKey, const TQVariant &var) const;
    TQStringList readListEntry( const TQString& pKey ) const;
    TQString readPathEntry( const TQString& pKey, const TQString & aDefault) const;
    TQStringList readPathListEntry( const TQString& pKey ) const;
    int readNumEntry( const TQString& pKey, int nDefault  ) const;
    uint readUnsignedNumEntry( const TQString& pKey, uint nDefault  ) const;
    long readLongNumEntry( const TQString& pKey, long nDefault  ) const;
    double readDoubleNumEntry( const TQString& pKey, double nDefault  ) const;
    TQFont readFontEntry( const TQString& pKey, const TQFont* pDefault) const;
    bool readBoolEntry( const TQString& pKey, const bool bDefault  ) const;
    TQRect readRectEntry( const TQString& pKey, const TQRect* pDefault) const;
    TQPoint readPointEntry( const TQString& pKey, const TQPoint* pDefault) const;
    TQSize readSizeEntry( const TQString& pKey, const TQSize* pDefault) const;
    TQColor readColorEntry( const TQString& pKey, const TQColor* pDefault) const;
    TQDateTime readDateTimeEntry( const TQString& pKey, const TQDateTime* pDefault) const;
    TQString readEntryUntranslated( const TQString& pKey, const TQString& aDefault  ) const;

    void writeEntry( const TQString& pKey, const TQString& pValue );
    void writePropertyEntry( const TQString& pKey, const TQVariant& pValue );
    void writeListEntry( const TQString& pKey, const TQStringList &rValue );
    void writeNumEntry( const TQString& pKey, int nValue );
    void writeUnsignedNumEntry( const TQString& pKey, uint nValue );
    void writeLongNumEntry( const TQString& pKey, unsigned long nValue );
    void writeDoubleNumEntry( const TQString& pKey, double nValue );
    void writeBoolEntry( const TQString& pKey, bool bValue );
    void writeFontEntry( const TQString& pKey, const TQFont& rFont );
    void writeColorEntry( const TQString& pKey, const TQColor& rColor );
    void writeDateTimeEntry( const TQString& pKey, const TQDateTime& rDateTime  );
    void writeRectEntry( const TQString& pKey, const TQRect& rValue );
    void writePointEntry( const TQString& pKey, const TQPoint& rValue );
    void writeSizeEntry( const TQString& pKey, const TQSize& rValue );
    void writePathEntry( const TQString& pKey, const TQString & path );
    void writePathListEntry( const TQString& pKey, const TQStringList &rValue);
    void deleteEntry( const TQString& pKey, bool bNLS , bool bGlobal );
    bool deleteGroup( const TQString& group, bool bDeep , bool bGlobal  );

private:
#ifndef QT_ONLY
    TDEConfig *m_config;
#else
    TQSettings *m_config;
    TQString m_name;
    bool m_forceGlobal;
#endif
};
}
}

#endif
