// TQPopupMenu.cs - A Qt to C# binding.
//
// Copyright (C) 2002  Adam Treat (manyoso@yahoo.com)
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//
// Regenerated by Adam Treat on August 03 2002
//
// TODO
// o Override Dispose method, make sure slots are disconnected.

namespace Qt {

    using Qt;
    using System;
	using System.Collections;
    using System.Runtime.InteropServices;

    public class TQPopupMenu : TQFrame, ITQMenuData, IDisposable {
		
		private Hashtable menuConnections;

		public Hashtable MenuConnections {
			get { return menuConnections; }
		}
        
		[DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_new_QPopupMenu (IntPtr parent, string name);
        public TQPopupMenu (TQWidget parent, string name) : this (TQNull.Instance)
        {
            qparent = parent;
            if (qparent == null) parent = new TQWidget (IntPtr.Zero);
            rawObject = qt_new_QPopupMenu (parent.RawObject, name);
            if (qparent == null) RegisterObject (this);
            else qparent.AddChild (this);
        }

        public TQPopupMenu () : this (new TQWidget ()) {}

        public TQPopupMenu (TQWidget parent) : this (parent, "") {}

        internal TQPopupMenu (IntPtr ptr) : this (TQNull.Instance)
        {
            rawObject = ptr;
            RegisterObject(this);
        }

        internal TQPopupMenu (TQNull dummy) : base (TQNull.Instance)
		{
			menuConnections = new Hashtable();
		}

        ~TQPopupMenu ()
        {
            Dispose (false);
        }

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern void qt_del_QPopupMenu (IntPtr obj);
		internal override void Delete ()
		{
			if (deleted) return;

			qt_del_QPopupMenu (rawObject);
			deleted = true;
		}

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QPopupMenu_popup (IntPtr raw, IntPtr pos, int indexAtPoint);
        public void Popup (TQPoint pos, int indexAtPoint)
        {
            qt_QPopupMenu_popup (rawObject, pos.RawObject, indexAtPoint);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QPopupMenu_updateItem (IntPtr raw, int identifier);
        public void UpdateItem (int identifier)
        {
            qt_QPopupMenu_updateItem (rawObject, identifier);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QPopupMenu_setCheckable (IntPtr raw, bool arg1);
        public void SetCheckable (bool arg1)
        {
            qt_QPopupMenu_setCheckable (rawObject, arg1);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern bool qt_QPopupMenu_isCheckable (IntPtr raw);
        public bool IsCheckable ()
        {
            return qt_QPopupMenu_isCheckable (rawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QPopupMenu_setFont (IntPtr raw, IntPtr arg1);
        public void SetFont (TQFont arg1)
        {
            qt_QPopupMenu_setFont (rawObject, arg1.RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QPopupMenu_show (IntPtr raw);
        public void Show ()
        {
            qt_QPopupMenu_show (rawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QPopupMenu_hide (IntPtr raw);
        public void Hide ()
        {
            qt_QPopupMenu_hide (rawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QPopupMenu_exec (IntPtr raw);
        public int Exec ()
        {
            return qt_QPopupMenu_exec (rawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QPopupMenu_exec1 (IntPtr raw, IntPtr pos, int indexAtPoint);
        public int Exec (TQPoint pos, int indexAtPoint)
        {
            return qt_QPopupMenu_exec1 (rawObject, pos.RawObject, indexAtPoint);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QPopupMenu_setActiveItem (IntPtr raw, int arg1);
        public void SetActiveItem (int arg1)
        {
            qt_QPopupMenu_setActiveItem (rawObject, arg1);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QPopupMenu_sizeHint (IntPtr raw);
        public TQSize SizeHint ()
        {
            return (TQSize)LookupObject (qt_QPopupMenu_sizeHint (rawObject), typeof(TQSize));
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QPopupMenu_idAt (IntPtr raw, int index);
        public int IdAt (int index)
        {
            return qt_QPopupMenu_idAt (rawObject, index);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QPopupMenu_idAt1 (IntPtr raw, IntPtr pos);
        public int IdAt (TQPoint pos)
        {
            return qt_QPopupMenu_idAt1 (rawObject, pos.RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern bool qt_QPopupMenu_customWhatsThis (IntPtr raw);
        public bool CustomWhatsThis ()
        {
            return qt_QPopupMenu_customWhatsThis (rawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QPopupMenu_insertTearOffHandle (IntPtr raw, int identifier, int index);
        public int InsertTearOffHandle (int identifier, int index)
        {
            return qt_QPopupMenu_insertTearOffHandle (rawObject, identifier, index);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QPopupMenu_activateItemAt (IntPtr raw, int index);
        public void ActivateItemAt (int index)
        {
            qt_QPopupMenu_activateItemAt (rawObject, index);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QPopupMenu_itemGeometry (IntPtr raw, int index);
        public TQRect ItemGeometry (int index)
        {
            return (TQRect)LookupObject (qt_QPopupMenu_itemGeometry (rawObject, index), typeof(TQRect));
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QPopupMenu_itemHeight (IntPtr raw, int arg1);
        protected int ItemHeight (int arg1)
        {
            return qt_QPopupMenu_itemHeight (rawObject, arg1);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QPopupMenu_itemHeight1 (IntPtr raw, IntPtr mi);
        protected int ItemHeight (TQMenuItem mi)
        {
            return qt_QPopupMenu_itemHeight1 (rawObject, mi.RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QPopupMenu_drawItem (IntPtr raw, IntPtr p, int tab, IntPtr mi, bool act, int x, int y, int w, int h);
        protected void DrawItem (TQPainter p, int tab, TQMenuItem mi, bool act, int x, int y, int w, int h)
        {
            qt_QPopupMenu_drawItem (rawObject, p.RawObject, tab, mi.RawObject, act, x, y, w, h);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QPopupMenu_drawContents (IntPtr raw, IntPtr arg1);
        protected void DrawContents (TQPainter arg1)
        {
            qt_QPopupMenu_drawContents (rawObject, arg1.RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QPopupMenu_styleChange (IntPtr raw, IntPtr arg1);
        protected void StyleChange (TQStyle arg1)
        {
            qt_QPopupMenu_styleChange (rawObject, arg1.RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QPopupMenu_columns (IntPtr raw);
        protected int Columns ()
        {
            return qt_QPopupMenu_columns (rawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern bool qt_QPopupMenu_focusNextPrevChild (IntPtr raw, bool next);
        protected bool FocusNextPrevChild (bool next)
        {
            return qt_QPopupMenu_focusNextPrevChild (rawObject, next);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QPopupMenu_itemAtPos (IntPtr raw, IntPtr arg1, bool ignoreSeparator);
        protected int ItemAtPos (TQPoint arg1, bool ignoreSeparator)
        {
            return qt_QPopupMenu_itemAtPos (rawObject, arg1.RawObject, ignoreSeparator);
        }

        public void Popup (TQPoint pos)
        {
            Popup(pos, (int) 0);
        }

        public int Exec (TQPoint pos)
        {
            return Exec(pos, (int) 0);
        }

        public int InsertTearOffHandle ()
        {
            return InsertTearOffHandle((int) -1);
        }

        public int InsertTearOffHandle (int identifier)
        {
            return InsertTearOffHandle(identifier, (int) -1);
        }

        protected int ItemAtPos (TQPoint arg1)
        {
            return ItemAtPos(arg1, true);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QPopupMenu_QMenuData (IntPtr raw);
        public IntPtr TQMenuData ()
        {
            return qt_QPopupMenu_QMenuData (rawObject);
        }

        // Begin interface methods.


		//********************* A temporary hack to divert connections to CSharpConnect *****************//

		public int InsertItem (string text, TQObject receiver, string member, TQKeySequence accel, int identifier, int index)
		{
			int id = InsertItem (text, identifier, index);
			SetAccel (accel, id);
			ConnectItem (id, receiver, member);
			return id;
		}

		public int InsertItem (TQIconSet icon, string text, TQObject receiver, string member, TQKeySequence accel, int identifier, int index)
		{
			int id = InsertItem (icon, text, identifier, index);
			SetAccel (accel, id);
			ConnectItem (id, receiver, member);
			return id;
		}

		public int InsertItem (TQPixmap pixmap, TQObject receiver, string member, TQKeySequence accel, int identifier, int index)
		{
			int id = InsertItem (pixmap, identifier, index);
			SetAccel (accel, id);
			ConnectItem (id, receiver, member);
			return id;
		}

		public int InsertItem (TQIconSet icon, TQPixmap pixmap, TQObject receiver, string member, TQKeySequence accel, int identifier, int index)
		{
			int id = InsertItem (icon, pixmap, identifier, index);
			SetAccel (accel, id);
			ConnectItem (id, receiver, member);
			return id;
		}

		public bool ConnectItem (int identifier, TQObject receiver, string member)
		{
			return Qt.TQMenuData.ConnectItem (this, TQMenuData (), identifier, receiver, member);
		}

		public bool DisconnectItem (int identifier, TQObject receiver, string member)
		{
			return Qt.TQMenuData.DisconnectItem (this, TQMenuData (), identifier, receiver, member);
		}

		//********************* A temporary hack to divert connections to CSharpConnect *****************//

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern uint qt_QMenuData_count (IntPtr raw);
        public uint Count ()
        {
            return qt_QMenuData_count (TQMenuData ());
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QMenuData_insertItem4 (IntPtr raw, IntPtr text, int identifier, int index);
        public int InsertItem (string text, int identifier, int index)
        {
            return qt_QMenuData_insertItem4 (TQMenuData (), new TQString (text).RawObject, identifier, index);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QMenuData_insertItem5 (IntPtr raw, IntPtr icon, IntPtr text, int identifier, int index);
        public int InsertItem (TQIconSet icon, string text, int identifier, int index)
        {
            return qt_QMenuData_insertItem5 (TQMenuData (), icon.RawObject, new TQString (text).RawObject, identifier, index);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QMenuData_insertItem6 (IntPtr raw, IntPtr text, IntPtr popup, int identifier, int index);
        public int InsertItem (string text, TQPopupMenu popup, int identifier, int index)
        {
            return qt_QMenuData_insertItem6 (TQMenuData (), new TQString (text).RawObject, popup.RawObject, identifier, index);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QMenuData_insertItem7 (IntPtr raw, IntPtr icon, IntPtr text, IntPtr popup, int identifier, int index);
        public int InsertItem (TQIconSet icon, string text, TQPopupMenu popup, int identifier, int index)
        {
            return qt_QMenuData_insertItem7 (TQMenuData (), icon.RawObject, new TQString (text).RawObject, popup.RawObject, identifier, index);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QMenuData_insertItem8 (IntPtr raw, IntPtr pixmap, int identifier, int index);
        public int InsertItem (TQPixmap pixmap, int identifier, int index)
        {
            return qt_QMenuData_insertItem8 (TQMenuData (), pixmap.RawObject, identifier, index);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QMenuData_insertItem9 (IntPtr raw, IntPtr icon, IntPtr pixmap, int identifier, int index);
        public int InsertItem (TQIconSet icon, TQPixmap pixmap, int identifier, int index)
        {
            return qt_QMenuData_insertItem9 (TQMenuData (), icon.RawObject, pixmap.RawObject, identifier, index);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QMenuData_insertItem10 (IntPtr raw, IntPtr pixmap, IntPtr popup, int identifier, int index);
        public int InsertItem (TQPixmap pixmap, TQPopupMenu popup, int identifier, int index)
        {
            return qt_QMenuData_insertItem10 (TQMenuData (), pixmap.RawObject, popup.RawObject, identifier, index);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QMenuData_insertItem11 (IntPtr raw, IntPtr icon, IntPtr pixmap, IntPtr popup, int identifier, int index);
        public int InsertItem (TQIconSet icon, TQPixmap pixmap, TQPopupMenu popup, int identifier, int index)
        {
            return qt_QMenuData_insertItem11 (TQMenuData (), icon.RawObject, pixmap.RawObject, popup.RawObject, identifier, index);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QMenuData_insertItem12 (IntPtr raw, IntPtr widget, int identifier, int index);
        public int InsertItem (TQWidget widget, int identifier, int index)
        {
            return qt_QMenuData_insertItem12 (TQMenuData (), widget.RawObject, identifier, index);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QMenuData_insertItem13 (IntPtr raw, IntPtr icon, IntPtr custom, int identifier, int index);
        public int InsertItem (TQIconSet icon, TQCustomMenuItem custom, int identifier, int index)
        {
            return qt_QMenuData_insertItem13 (TQMenuData (), icon.RawObject, custom.RawObject, identifier, index);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QMenuData_insertItem14 (IntPtr raw, IntPtr custom, int identifier, int index);
        public int InsertItem (TQCustomMenuItem custom, int identifier, int index)
        {
            return qt_QMenuData_insertItem14 (TQMenuData (), custom.RawObject, identifier, index);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QMenuData_insertSeparator (IntPtr raw, int index);
        public int InsertSeparator (int index)
        {
            return qt_QMenuData_insertSeparator (TQMenuData (), index);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_removeItem (IntPtr raw, int identifier);
        public void RemoveItem (int identifier)
        {
            qt_QMenuData_removeItem (TQMenuData (), identifier);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_removeItemAt (IntPtr raw, int index);
        public void RemoveItemAt (int index)
        {
            qt_QMenuData_removeItemAt (TQMenuData (), index);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_clear (IntPtr raw);
        public void Clear ()
        {
            qt_QMenuData_clear (TQMenuData ());
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QMenuData_accel (IntPtr raw, int identifier);
        public TQKeySequence Accel (int identifier)
        {
            return (TQKeySequence)LookupObject (qt_QMenuData_accel (TQMenuData (), identifier), typeof(TQKeySequence));
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_setAccel (IntPtr raw, IntPtr key, int identifier);
        public void SetAccel (TQKeySequence key, int identifier)
        {
            qt_QMenuData_setAccel (TQMenuData (), key.RawObject, identifier);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QMenuData_iconSet (IntPtr raw, int identifier);
        public TQIconSet IconSet (int identifier)
        {
            return (TQIconSet)LookupObject (qt_QMenuData_iconSet (TQMenuData (), identifier), typeof(TQIconSet));
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QMenuData_text (IntPtr raw, int identifier);
        public string Text (int identifier)
        {
			TQString qstr = new TQString (qt_QMenuData_text (TQMenuData (), identifier));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QMenuData_pixmap (IntPtr raw, int identifier);
        public TQPixmap Pixmap (int identifier)
        {
            return (TQPixmap)LookupObject (qt_QMenuData_pixmap (TQMenuData (), identifier), typeof(TQPixmap));
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_setWhatsThis (IntPtr raw, int identifier, IntPtr arg1);
        public void SetWhatsThis (int identifier, string arg1)
        {
            qt_QMenuData_setWhatsThis (TQMenuData (), identifier, new TQString (arg1).RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QMenuData_whatsThis (IntPtr raw, int identifier);
        public string WhatsThis (int identifier)
        {
			TQString qstr = new TQString (qt_QMenuData_whatsThis (TQMenuData (), identifier));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_changeItem (IntPtr raw, int identifier, IntPtr text);
        public void ChangeItem (int identifier, string text)
        {
            qt_QMenuData_changeItem (TQMenuData (), identifier, new TQString (text).RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_changeItem1 (IntPtr raw, int identifier, IntPtr pixmap);
        public void ChangeItem (int identifier, TQPixmap pixmap)
        {
            qt_QMenuData_changeItem1 (TQMenuData (), identifier, pixmap.RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_changeItem2 (IntPtr raw, int identifier, IntPtr icon, IntPtr text);
        public void ChangeItem (int identifier, TQIconSet icon, string text)
        {
            qt_QMenuData_changeItem2 (TQMenuData (), identifier, icon.RawObject, new TQString (text).RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_changeItem3 (IntPtr raw, int identifier, IntPtr icon, IntPtr pixmap);
        public void ChangeItem (int identifier, TQIconSet icon, TQPixmap pixmap)
        {
            qt_QMenuData_changeItem3 (TQMenuData (), identifier, icon.RawObject, pixmap.RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_changeItem4 (IntPtr raw, IntPtr text, int identifier);
        public void ChangeItem (string text, int identifier)
        {
            qt_QMenuData_changeItem4 (TQMenuData (), new TQString (text).RawObject, identifier);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_changeItem5 (IntPtr raw, IntPtr pixmap, int identifier);
        public void ChangeItem (TQPixmap pixmap, int identifier)
        {
            qt_QMenuData_changeItem5 (TQMenuData (), pixmap.RawObject, identifier);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_changeItem6 (IntPtr raw, IntPtr icon, IntPtr text, int identifier);
        public void ChangeItem (TQIconSet icon, string text, int identifier)
        {
            qt_QMenuData_changeItem6 (TQMenuData (), icon.RawObject, new TQString (text).RawObject, identifier);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern bool qt_QMenuData_isItemActive (IntPtr raw, int identifier);
        public bool IsItemActive (int identifier)
        {
            return qt_QMenuData_isItemActive (TQMenuData (), identifier);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern bool qt_QMenuData_isItemEnabled (IntPtr raw, int identifier);
        public bool IsItemEnabled (int identifier)
        {
            return qt_QMenuData_isItemEnabled (TQMenuData (), identifier);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_setItemEnabled (IntPtr raw, int identifier, bool enable);
        public void SetItemEnabled (int identifier, bool enable)
        {
            qt_QMenuData_setItemEnabled (TQMenuData (), identifier, enable);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern bool qt_QMenuData_isItemChecked (IntPtr raw, int identifier);
        public bool IsItemChecked (int identifier)
        {
            return qt_QMenuData_isItemChecked (TQMenuData (), identifier);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_setItemChecked (IntPtr raw, int identifier, bool check);
        public void SetItemChecked (int identifier, bool check)
        {
            qt_QMenuData_setItemChecked (TQMenuData (), identifier, check);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QMenuData_indexOf (IntPtr raw, int identifier);
        public int IndexOf (int identifier)
        {
            return qt_QMenuData_indexOf (TQMenuData (), identifier);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_setId (IntPtr raw, int index, int identifier);
        public void SetId (int index, int identifier)
        {
            qt_QMenuData_setId (TQMenuData (), index, identifier);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern bool qt_QMenuData_setItemParameter (IntPtr raw, int identifier, int param);
        public bool SetItemParameter (int identifier, int param)
        {
            return qt_QMenuData_setItemParameter (TQMenuData (), identifier, param);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QMenuData_itemParameter (IntPtr raw, int identifier);
        public int ItemParameter (int identifier)
        {
            return qt_QMenuData_itemParameter (TQMenuData (), identifier);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QMenuData_findItem (IntPtr raw, int identifier);
        public TQMenuItem FindItem (int identifier)
        {
            return (TQMenuItem)LookupObject (qt_QMenuData_findItem (TQMenuData (), identifier), typeof(TQMenuItem));
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QMenuData_findItem1 (IntPtr raw, int identifier, IntPtr parent);
        public TQMenuItem FindItem (int identifier, TQMenuData parent)
        {
            return (TQMenuItem)LookupObject (qt_QMenuData_findItem1 (TQMenuData (), identifier, parent.RawObject), typeof(TQMenuItem));
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QMenuData_findPopup (IntPtr raw, IntPtr arg1, int[] index);
        public TQMenuItem FindPopup (TQPopupMenu arg1, int[] index)
        {
            return (TQMenuItem)LookupObject (qt_QMenuData_findPopup (TQMenuData (), arg1.RawObject, index), typeof(TQMenuItem));
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_menuInsPopup (IntPtr raw, IntPtr arg1);
        protected void MenuInsPopup (TQPopupMenu arg1)
        {
            qt_QMenuData_menuInsPopup (TQMenuData (), arg1.RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_menuDelPopup (IntPtr raw, IntPtr arg1);
        protected void MenuDelPopup (TQPopupMenu arg1)
        {
            qt_QMenuData_menuDelPopup (TQMenuData (), arg1.RawObject);
        }

        public int InsertItem (string text, TQObject receiver, string member)
        {
            return InsertItem(text, receiver, member, new TQKeySequence ());
        }

        public int InsertItem (string text, TQObject receiver, string member, TQKeySequence accel)
        {
            return InsertItem(text, receiver, member, accel, (int) -1);
        }

        public int InsertItem (string text, TQObject receiver, string member, TQKeySequence accel, int identifier)
        {
            return InsertItem(text, receiver, member, accel, identifier, (int) -1);
        }

        public int InsertItem (TQIconSet icon, string text, TQObject receiver, string member)
        {
            return InsertItem(icon, text, receiver, member, new TQKeySequence ());
        }

        public int InsertItem (TQIconSet icon, string text, TQObject receiver, string member, TQKeySequence accel)
        {
            return InsertItem(icon, text, receiver, member, accel, (int) -1);
        }

        public int InsertItem (TQIconSet icon, string text, TQObject receiver, string member, TQKeySequence accel, int identifier)
        {
            return InsertItem(icon, text, receiver, member, accel, identifier, (int) -1);
        }

        public int InsertItem (TQPixmap pixmap, TQObject receiver, string member)
        {
            return InsertItem(pixmap, receiver, member, new TQKeySequence ());
        }

        public int InsertItem (TQPixmap pixmap, TQObject receiver, string member, TQKeySequence accel)
        {
            return InsertItem(pixmap, receiver, member, accel, (int) -1);
        }

        public int InsertItem (TQPixmap pixmap, TQObject receiver, string member, TQKeySequence accel, int identifier)
        {
            return InsertItem(pixmap, receiver, member, accel, identifier, (int) -1);
        }

        public int InsertItem (TQIconSet icon, TQPixmap pixmap, TQObject receiver, string member)
        {
            return InsertItem(icon, pixmap, receiver, member, new TQKeySequence ());
        }

        public int InsertItem (TQIconSet icon, TQPixmap pixmap, TQObject receiver, string member, TQKeySequence accel)
        {
            return InsertItem(icon, pixmap, receiver, member, accel, (int) -1);
        }

        public int InsertItem (TQIconSet icon, TQPixmap pixmap, TQObject receiver, string member, TQKeySequence accel, int identifier)
        {
            return InsertItem(icon, pixmap, receiver, member, accel, identifier, (int) -1);
        }

        public int InsertItem (string text)
        {
            return InsertItem(text, (int) -1);
        }

        public int InsertItem (string text, int identifier)
        {
            return InsertItem(text, identifier, (int) -1);
        }

        public int InsertItem (TQIconSet icon, string text)
        {
            return InsertItem(icon, text, (int) -1);
        }

        public int InsertItem (TQIconSet icon, string text, int identifier)
        {
            return InsertItem(icon, text, identifier, (int) -1);
        }

        public int InsertItem (string text, TQPopupMenu popup)
        {
            return InsertItem(text, popup, (int) -1);
        }

        public int InsertItem (string text, TQPopupMenu popup, int identifier)
        {
            return InsertItem(text, popup, identifier, (int) -1);
        }

        public int InsertItem (TQIconSet icon, string text, TQPopupMenu popup)
        {
            return InsertItem(icon, text, popup, (int) -1);
        }

        public int InsertItem (TQIconSet icon, string text, TQPopupMenu popup, int identifier)
        {
            return InsertItem(icon, text, popup, identifier, (int) -1);
        }

        public int InsertItem (TQPixmap pixmap)
        {
            return InsertItem(pixmap, (int) -1);
        }

        public int InsertItem (TQPixmap pixmap, int identifier)
        {
            return InsertItem(pixmap, identifier, (int) -1);
        }

        public int InsertItem (TQIconSet icon, TQPixmap pixmap)
        {
            return InsertItem(icon, pixmap, (int) -1);
        }

        public int InsertItem (TQIconSet icon, TQPixmap pixmap, int identifier)
        {
            return InsertItem(icon, pixmap, identifier, (int) -1);
        }

        public int InsertItem (TQPixmap pixmap, TQPopupMenu popup)
        {
            return InsertItem(pixmap, popup, (int) -1);
        }

        public int InsertItem (TQPixmap pixmap, TQPopupMenu popup, int identifier)
        {
            return InsertItem(pixmap, popup, identifier, (int) -1);
        }

        public int InsertItem (TQIconSet icon, TQPixmap pixmap, TQPopupMenu popup)
        {
            return InsertItem(icon, pixmap, popup, (int) -1);
        }

        public int InsertItem (TQIconSet icon, TQPixmap pixmap, TQPopupMenu popup, int identifier)
        {
            return InsertItem(icon, pixmap, popup, identifier, (int) -1);
        }

        public int InsertItem (TQWidget widget)
        {
            return InsertItem(widget, (int) -1);
        }

        public int InsertItem (TQWidget widget, int identifier)
        {
            return InsertItem(widget, identifier, (int) -1);
        }

        public int InsertItem (TQIconSet icon, TQCustomMenuItem custom)
        {
            return InsertItem(icon, custom, (int) -1);
        }

        public int InsertItem (TQIconSet icon, TQCustomMenuItem custom, int identifier)
        {
            return InsertItem(icon, custom, identifier, (int) -1);
        }

        public int InsertItem (TQCustomMenuItem custom)
        {
            return InsertItem(custom, (int) -1);
        }

        public int InsertItem (TQCustomMenuItem custom, int identifier)
        {
            return InsertItem(custom, identifier, (int) -1);
        }

        public int InsertSeparator ()
        {
            return InsertSeparator((int) -1);
        }

        public TQMenuItem FindPopup (TQPopupMenu arg1)
        {
            return FindPopup(arg1, new int[]{0});
        }
    }
}
