


#include <tqcstring.h>
#include <tqimage.h>
#include <tqpainter.h>
#include <tqpalette.h>
#include <tqpixmap.h>
#include <tqfont.h>

#include <kjs/object.h>

#include <kjsembed/global.h>
#include <kjsembed/jsobjectproxy.h>
#include <kjsembed/jsopaqueproxy.h>
#include <kjsembed/jsbinding.h>

#include <tqcanvas.h>
#include "qcanvastext_imp.h"

/**
 * Namespace containing the KJSEmbed library.
 */
namespace KJSEmbed {

TQCanvasTextImp::TQCanvasTextImp( KJS::ExecState *exec, int mid, bool constructor )
   : JSProxyImp(exec), id(mid), cons(constructor)
{
}

TQCanvasTextImp::~TQCanvasTextImp()
{
}

/**
 * Adds bindings for static methods and enum constants to the specified Object.
 */
void TQCanvasTextImp::addStaticBindings( KJS::ExecState *exec, KJS::Object &object )
{
    JSProxy::MethodTable methods[] = {

	{ 0, 0 }
    };

    int idx = 0;
    TQCString lastName;

    while( methods[idx].name ) {
        if ( lastName != methods[idx].name ) {
            TQCanvasTextImp *meth = new TQCanvasTextImp( exec, methods[idx].id );
            object.put( exec , methods[idx].name, KJS::Object(meth) );
            lastName = methods[idx].name;
        }
        ++idx;
    }


}

/**
 * Adds bindings for instance methods to the specified Object.
 */
void TQCanvasTextImp::addBindings( KJS::ExecState *exec, KJS::Object &object )
{
    JSProxy::MethodTable methods[] = {

        { Method_setText_5, "setText" },
        { Method_setFont_6, "setFont" },
        { Method_setColor_7, "setColor" },
        { Method_text_8, "text" },
        { Method_font_9, "font" },
        { Method_color_10, "color" },
        { Method_moveBy_11, "moveBy" },
        { Method_textFlags_12, "textFlags" },
        { Method_setTextFlags_13, "setTextFlags" },
        { Method_boundingRect_14, "boundingRect" },
        { Method_collidesWith_15, "collidesWith" },
        { Method_rtti_16, "rtti" },
	{ 0, 0 }
    };

    int idx = 0;
    TQCString lastName;

    while( methods[idx].name ) {
        if ( lastName != methods[idx].name ) {
            TQCanvasTextImp *meth = new TQCanvasTextImp( exec, methods[idx].id );
            object.put( exec , methods[idx].name, KJS::Object(meth) );
            lastName = methods[idx].name;
        }
        ++idx;
    }
}

/**
 * Extract a TQCanvasText pointer from an Object.
 */
TQCanvasText *TQCanvasTextImp::toTQCanvasText( KJS::Object &self )
{
    JSObjectProxy *ob = JSProxy::toObjectProxy( self.imp() );
    if ( ob ) {
        TQObject *obj = ob->object();
	if ( obj )
           return dynamic_cast<TQCanvasText *>( obj );
    }

    JSOpaqueProxy *op = JSProxy::toOpaqueProxy( self.imp() );
    if ( !op )
        return 0;

    if ( op->typeName() != "TQCanvasText" )
        return 0;

    return op->toNative<TQCanvasText>();
}

/**
 * Select and invoke the correct constructor.
 */
KJS::Object TQCanvasTextImp::construct( KJS::ExecState *exec, const KJS::List &args )
{
   switch( id ) {

         case Constructor_QCanvasText_1:
             return TQCanvasText_1( exec, args );
             break;

         case Constructor_QCanvasText_2:
             return TQCanvasText_2( exec, args );
             break;

         case Constructor_QCanvasText_3:
             return TQCanvasText_3( exec, args );
             break;

         default:
             break;
    }

    TQString msg = i18n("TQCanvasTextCons has no constructor with id '%1'.").arg(id);
    return throwError(exec, msg,KJS::ReferenceError);
}


KJS::Object TQCanvasTextImp::TQCanvasText_1( KJS::ExecState *exec, const KJS::List &args )
{

    // Unsupported parameter TQCanvas *
    return KJS::Object();

    TQCanvas * arg0; // Dummy


    // We should now create an instance of the TQCanvasText object

    TQCanvasText *ret = new TQCanvasText(

          arg0 );


}

KJS::Object TQCanvasTextImp::TQCanvasText_2( KJS::ExecState *exec, const KJS::List &args )
{

    TQString arg0 = extractTQString(exec, args, 0);

    // Unsupported parameter TQCanvas *
    return KJS::Object();

    TQCanvas * arg1; // Dummy


    // We should now create an instance of the TQCanvasText object

    TQCanvasText *ret = new TQCanvasText(

          arg0,
          arg1 );


}

KJS::Object TQCanvasTextImp::TQCanvasText_3( KJS::ExecState *exec, const KJS::List &args )
{

    TQString arg0 = extractTQString(exec, args, 0);

    // Unsupported parameter TQFont
    return KJS::Object();

    TQFont arg1; // Dummy

    // Unsupported parameter TQCanvas *
    return KJS::Object();

    TQCanvas * arg2; // Dummy


    // We should now create an instance of the TQCanvasText object

    TQCanvasText *ret = new TQCanvasText(

          arg0,
          arg1,
          arg2 );


}

KJS::Value TQCanvasTextImp::call( KJS::ExecState *exec, KJS::Object &self, const KJS::List &args )
{
    instance = TQCanvasTextImp::toTQCanvasText( self );

    switch( id ) {

    case Method_setText_5:
        return setText_5( exec, self, args );
        break;

    case Method_setFont_6:
        return setFont_6( exec, self, args );
        break;

    case Method_setColor_7:
        return setColor_7( exec, self, args );
        break;

    case Method_text_8:
        return text_8( exec, self, args );
        break;

    case Method_font_9:
        return font_9( exec, self, args );
        break;

    case Method_color_10:
        return color_10( exec, self, args );
        break;

    case Method_moveBy_11:
        return moveBy_11( exec, self, args );
        break;

    case Method_textFlags_12:
        return textFlags_12( exec, self, args );
        break;

    case Method_setTextFlags_13:
        return setTextFlags_13( exec, self, args );
        break;

    case Method_boundingRect_14:
        return boundingRect_14( exec, self, args );
        break;

    case Method_collidesWith_15:
        return collidesWith_15( exec, self, args );
        break;

    case Method_rtti_16:
        return rtti_16( exec, self, args );
        break;

    default:
        break;
    }

    TQString msg = i18n( "TQCanvasTextImp has no method with id '%1'." ).arg( id );
    return throwError(exec, msg,KJS::ReferenceError);
}


KJS::Value TQCanvasTextImp::setText_5( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    TQString arg0 = extractTQString(exec, args, 0);

      instance->setText(
       arg0 );
      return KJS::Value(); // Returns void

}

KJS::Value TQCanvasTextImp::setFont_6( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    TQFont arg0 = extractTQFont(exec, args, 0);

      instance->setFont(
       arg0 );
      return KJS::Value(); // Returns void

}

KJS::Value TQCanvasTextImp::setColor_7( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    TQColor arg0 = extractTQColor(exec, args, 0);

      instance->setColor(
       arg0 );
      return KJS::Value(); // Returns void

}

KJS::Value TQCanvasTextImp::text_8( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      TQString ret;
      ret = instance->text(  );
      return KJS::String( ret );

}

KJS::Value TQCanvasTextImp::font_9( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      instance->font(  );
      return KJS::Value(); // Returns 'TQFont'

}

KJS::Value TQCanvasTextImp::color_10( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      instance->color(  );
      return KJS::Value(); // Returns 'TQColor'

}

KJS::Value TQCanvasTextImp::moveBy_11( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    double arg0 = extractDouble(exec, args, 0);

    double arg1 = extractDouble(exec, args, 1);

      instance->moveBy(
       arg0,
       arg1 );
      return KJS::Value(); // Returns void

}

KJS::Value TQCanvasTextImp::textFlags_12( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      int ret;
      ret = instance->textFlags(  );
      return KJS::Number( ret );

}

KJS::Value TQCanvasTextImp::setTextFlags_13( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    int arg0 = extractInt(exec, args, 0);

      instance->setTextFlags(
       arg0 );
      return KJS::Value(); // Returns void

}

KJS::Value TQCanvasTextImp::boundingRect_14( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    TQRect ret;
      ret = instance->boundingRect(  );

       return convertToValue( exec, ret );

}

KJS::Value TQCanvasTextImp::collidesWith_15( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    // Unsupported parameter const TQCanvasItem *
    return KJS::Value();

    const TQCanvasItem * arg0; // Dummy

      bool ret;
      ret = instance->collidesWith(
       arg0 );
      return KJS::Boolean( ret );

}

KJS::Value TQCanvasTextImp::rtti_16( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      int ret;
      ret = instance->rtti(  );
      return KJS::Number( ret );

}


} // namespace KJSEmbed

// Local Variables:
// c-basic-offset: 4
// End:


