
  

#ifndef KJSEMBED_QCanvas_H
#define KJSEMBED_QCanvas_H

#include <kjs/interpreter.h>
#include <kjs/object.h>

#include <kjsembed/jsobjectproxy_imp.h>

class TQCanvas;

/**
 * Namespace containing the KJSEmbed library.
 */
namespace KJSEmbed {

/**
 * Wrapper class for TQCanvas methods.
 *
 * @author Richard Moore, rich@kde.org
 */
class TQCanvasImp : public JSProxyImp
{
public:
   /** Enumerates the constructors supported by this class. */
   enum Constructors {
       Constructor_QCanvas_1,
       Constructor_QCanvas_2,
       Constructor_QCanvas_3,

       LastConstuctor = -1
   };

   /** Enumerates the methods supported by this class. */
   enum Methods {

       Method_setTiles_5,
       Method_setBackgroundPixmap_6,
       Method_backgroundPixmap_7,
       Method_setBackgroundColor_8,
       Method_backgroundColor_9,
       Method_setTile_10,
       Method_tile_11,
       Method_tilesHorizontally_12,
       Method_tilesVertically_13,
       Method_tileWidth_14,
       Method_tileHeight_15,
       Method_resize_16,
       Method_width_17,
       Method_height_18,
       Method_size_19,
       Method_rect_20,
       Method_onCanvas_21,
       Method_onCanvas_22,
       Method_validChunk_23,
       Method_validChunk_24,
       Method_chunkSize_25,
       Method_retune_26,
       Method_sameChunk_27,
       Method_setChangedChunk_28,
       Method_setChangedChunkContaining_29,
       Method_setAllChanged_30,
       Method_setChanged_31,
       Method_setUnchanged_32,
       Method_addItemToChunk_33,
       Method_removeItemFromChunk_34,
       Method_addItemToChunkContaining_35,
       Method_removeItemFromChunkContaining_36,
       Method_allItems_37,
       Method_collisions_38,
       Method_collisions_39,
       Method_collisions_40,
       Method_drawArea_41,
       Method_addView_42,
       Method_removeView_43,
       Method_drawCanvasArea_44,
       Method_drawViewArea_45,
       Method_addItem_46,
       Method_addAnimation_47,
       Method_removeItem_48,
       Method_removeAnimation_49,
       Method_setAdvancePeriod_50,
       Method_setUpdatePeriod_51,
       Method_setDoubleBuffering_52,
       Method_Last = -1
   };

   TQCanvasImp( KJS::ExecState *exec, int id, bool constructor=false );
   ~TQCanvasImp();

   /**
    * Adds the static bindings for this class to the specified Object. The
    * static bindings are the static methods and the enums of this class.
    */
   static void addStaticBindings( KJS::ExecState *exec, KJS::Object &object );

   /**
    * Adds the bindings for this class to the specified Object. The bindings
    * added are the instance methods of this class.
    */
   static void addBindings( KJS::ExecState *exec, KJS::Object &object );

   static TQCanvas *toTQCanvas( KJS::Object &object );

   //
   // Constructors implemented by this class.
   //

   KJS::Object TQCanvas_1( KJS::ExecState *exec, const KJS::List &args );
   KJS::Object TQCanvas_2( KJS::ExecState *exec, const KJS::List &args );
   KJS::Object TQCanvas_3( KJS::ExecState *exec, const KJS::List &args );

   //
   // Methods implemented by this class.
   //

   KJS::Value setTiles_5( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value setBackgroundPixmap_6( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value backgroundPixmap_7( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value setBackgroundColor_8( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value backgroundColor_9( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value setTile_10( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value tile_11( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value tilesHorizontally_12( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value tilesVertically_13( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value tileWidth_14( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value tileHeight_15( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value resize_16( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value width_17( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value height_18( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value size_19( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value rect_20( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value onCanvas_21( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value onCanvas_22( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value validChunk_23( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value validChunk_24( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value chunkSize_25( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value retune_26( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value sameChunk_27( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value setChangedChunk_28( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value setChangedChunkContaining_29( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value setAllChanged_30( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value setChanged_31( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value setUnchanged_32( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value addItemToChunk_33( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value removeItemFromChunk_34( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value addItemToChunkContaining_35( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value removeItemFromChunkContaining_36( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value allItems_37( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value collisions_38( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value collisions_39( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value collisions_40( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value drawArea_41( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value addView_42( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value removeView_43( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value drawCanvasArea_44( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value drawViewArea_45( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value addItem_46( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value addAnimation_47( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value removeItem_48( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value removeAnimation_49( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value setAdvancePeriod_50( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value setUpdatePeriod_51( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value setDoubleBuffering_52( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );

   //
   // JS binding code.
   //

   /** Returns true iff this object implements the construct function. */
   virtual bool implementsConstruct() const { return cons; }

   /** Invokes the construct function. */
   virtual KJS::Object construct( KJS::ExecState *exec, const KJS::List &args );

   /** Returns true iff this object implements the call function. */
   virtual bool implementsCall() const { return !cons; }

   /** Invokes the call function. */
   virtual KJS::Value call( KJS::ExecState *exec, KJS::Object &self, const KJS::List &args );

private:
   TQCanvas *instance; // Temp
   int id;
   bool cons;
};

} // namespace KJSEmbed

#endif // KJSEMBED_QCanvas_H

// Local Variables:
// c-basic-offset: 4
// End:


