#################################################
#
#  (C) 2011 Golubev Alexander
#  fatzer2 (AT) gmail.com
#
#  Improvements and feedback are welcome
#
#  This file is released under GPL >= 2
#
#################################################

##### check for gcc visibility support #########
# FIXME
# This should check for [T]Qt3 visibility support

if( WITH_GCC_VISIBILITY )
  if( NOT UNIX )
    tde_message_fatal(FATAL_ERROR "\ngcc visibility support was requested, but your system is not *NIX" )
  endif( NOT UNIX )
  set( __KDE_HAVE_GCC_VISIBILITY 1 )
  set( CMAKE_C_FLAGS "${CMAKE_C_FLAGS} -fvisibility=hidden -fvisibility-inlines-hidden")
  set( CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -fvisibility=hidden -fvisibility-inlines-hidden")
endif( )


if( BUILD_TDESCREENSAVER )
  # limits.h (tdescreensaver/kdesavers) 
  check_include_file_cxx( limits HAVE_NUMERIC_LIMITS )
  
  # memory.h (tdescreensaver/xsavers) 
  check_include_file( memory.h HAVE_MEMORY_H )

  # X11/dirent.h (tdescreensaver/xsavers)
  check_include_file( X11/dirent.h HAVE_DIRENT_H )

  # sys/ndir.h (tdescreensaver/xsavers)
  check_include_file( sys/ndir.h HAVE_SYS_NDIR_H )

  # sys/dir.h (tdescreensaver/xsavers)
  check_include_file( sys/dir.h HAVE_SYS_DIR_H )

  # ndir.h (tdescreensaver/xsavers)
  check_include_file( ndir.h HAVE_NDIR_H )
  
  # OpenGL(tdescreensaver/kdesavers)
  if( WITH_OPENGL )
    find_package( OpenGL REQUIRED )
    if( NOT OPENGL_FOUND )
      tde_message_fatal( "OpenGL is required, but was not found on your system" )
    endif( NOT OPENGL_FOUND )
    
	# for tdescreensaver/xsavers
	set( HAVE_GL ${OPENGL_FOUND} )
    
	# GL/xmesa.h (tdescreensaver/xsavers)
    check_include_file( GL/xmesa.h HAVE_GL_XMESA_H )

    # GL/glut.h (tdescreensaver/xsavers)
    check_include_file( GL/glut.h HAVE_GL_XMESA_H )

  endif( WITH_OPENGL )
  
  # libart(tdescreensaver/kdesavers)
  if( WITH_LIBART )
    pkg_search_module( LIBART libart libart_lgpl libart-2.0 )
    if( NOT LIBART_FOUND )
      tde_message_fatal( "libart is required, but was not found on your system" )
    endif( NOT LIBART_FOUND  )
  endif( WITH_LIBART )
  
  # arts(tdescreensaver/kdesavers)
  if( WITH_ARTS )
    pkg_search_module( ARTS arts )
    if( NOT ARTS_FOUND )
      message( FATAL_ERROR "\naRts is requested, but was not found on your system" )
    endif( )
  endif( WITH_ARTS )
  
  # xscreensavers(tdescreensaver/kxsconfig)
  if( WITH_XSCREENSAVER )
    find_package( X11 )
    if( NOT X11_FOUND OR NOT X11_Xt_FOUND )
      message( FATAL_ERROR 
  		"\nX11 and Xt library is required for xscreensaver support, but it was not found on your system" )
    endif( )
    include( FindXscreensaver.cmake ) # not really good practise
    if( NOT XSCREENSAVER_FOUND )
      message( FATAL_ERROR "\nxscreensaver is requested, but was not found on your system" )
    endif( )
  endif( WITH_XSCREENSAVER )
endif( BUILD_TDESCREENSAVER )

# required stuff
find_package( TQt )
find_package( TDE )
