/***************************************************************************
 *   Copyright (C) 2005 by Florian Roth   *
 *   florian@synatic.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
 
#ifndef METABAR_WIDGET_H
#define METABAR_WIDGET_H

#include <tdehtml_part.h>

#include <tdeconfig.h>
#include <tdefileitem.h>
#include <kurl.h>
#include <kservice.h>
#include <tdepopupmenu.h>
#include <kdirwatch.h>

#include <tqmap.h>

#include "protocolplugin.h"
#include "metabarfunctions.h"

class MetabarWidget : public TQWidget
{
  Q_OBJECT
  
    
  public:
    MetabarWidget(TQWidget *parent = 0, const char* name=0);
    ~MetabarWidget();
    
    void setFileItems(const KFileItemList &items, bool check = true);
    
    static TQString getIconPath(const TQString &name);
    static void addEntry(DOM::DOMString &html, const TQString name, const TQString url, const TQString icon, const TQString id = TQString(), const TQString nameatt = TQString(), bool hidden = false);
    
  private:
    KFileItemList *currentItems;
    TDEConfig *config;

    TDEHTMLPart *html;
    
    ProtocolPlugin *currentPlugin;
    ProtocolPlugin *defaultPlugin;
    
    MetabarFunctions *functions;
    
    KDirWatch *dir_watch;
    TDEPopupMenu *popup;
  
    TQDict<ProtocolPlugin> plugins;
    
    bool skip;
    bool loadComplete;

    void callAction(const TQString &action);
    void openURL(const TQString &url);
    void openTab(const TQString &url);
    void loadLinks();
    
    TQString getCurrentURL();
    
  private slots:
    void loadCompleted();
    void slotShowSharingDialog();
    void slotShowConfig();
    void slotShowPopup(const TQString &url, const TQPoint &pos);
    void handleURLRequest(const KURL &url, const KParts::URLArgs &args);
    void slotUpdateCurrentInfo(const TQString &path);
    void slotDeleteCurrentInfo(const TQString &path);
    void setTheme();
};

#endif
