/*****************************************************************

Copyright (c) 2000-2001 the noatun authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIAB\ILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#include "controls.h"

L33tSlider::L33tSlider(TQWidget * parent, const char * name) :
	TQSlider(parent,name), pressed(false)
{}
L33tSlider::L33tSlider(Qt::Orientation o, TQWidget * parent, const char * name) :
	TQSlider(o,parent,name), pressed(false)
{}
L33tSlider::L33tSlider(int minValue, int maxValue, int pageStep, int value,
	                   Qt::Orientation o, TQWidget * parent, const char * name) :
	TQSlider(minValue, maxValue, pageStep, value, o, parent,name), pressed(false)
{}

bool L33tSlider::currentlyPressed() const
{
	return pressed;
}

void L33tSlider::setValue(int i)
{
	if (!pressed)
		TQSlider::setValue(i);
}

void L33tSlider::mousePressEvent(TQMouseEvent*e)
{
	if (e->button()!=Qt::RightButton)
	{
		pressed=true;
		TQSlider::mousePressEvent(e);
	}
}

void L33tSlider::mouseReleaseEvent(TQMouseEvent*e)
{
	pressed=false;
	TQSlider::mouseReleaseEvent(e);
	emit userChanged(value());
}

void L33tSlider::wheelEvent(TQWheelEvent *e)
{
	TQSlider::wheelEvent(e);
	int newValue = value();

	if(newValue < minValue())
		newValue = minValue();
	else if(newValue > maxValue())
		newValue = maxValue();

	setValue(newValue);
	emit userChanged(newValue);
}

SliderAction::SliderAction(const TQString& text, int accel, const TQObject *receiver,
                                 const char *member, TQObject* parent, const char* name )
	: TDEAction( text, accel, parent, name )
{
	m_receiver = receiver;
	m_member = member;
}

int SliderAction::plug( TQWidget *w, int index )
{
	if (!w->inherits("TDEToolBar")) return -1;

	TDEToolBar *toolBar = (TDEToolBar *)w;
	int id = TDEAction::getToolButtonID();

	//Create it.
	m_slider=new L33tSlider(0, 1000, 100, 0,Qt::Horizontal, toolBar);
	m_slider->setMinimumWidth(10);
	toolBar->insertWidget(id, 10, m_slider, index );


	addContainer( toolBar, id );
	connect( toolBar, TQT_SIGNAL( destroyed() ), this, TQT_SLOT( slotDestroyed() ) );
	toolBar->setItemAutoSized( id, true );

	if (w->inherits( "TDEToolBar" ))
		connect(toolBar, TQT_SIGNAL(moved(TDEToolBar::BarPosition)), this, TQT_SLOT(toolbarMoved(TDEToolBar::BarPosition)));

	emit plugged();

	return containerCount() - 1;
}

void SliderAction::toolbarMoved(TDEToolBar::BarPosition)
{
// I wish this worked :)
return;
/*
	if (pos == TDEToolBar::Left || pos == TDEToolBar::Right)
	{
		m_slider->setOrientation(Qt::Vertical);
		m_slider->setFixedWidth(m_slider->height());
	}
	else
	{
		m_slider->setOrientation(Qt::Horizontal);
		m_slider->resize(m_slider->height(), m_slider->height());
	}
*/
}

void SliderAction::unplug( TQWidget *w )
{
	TDEToolBar *toolBar = (TDEToolBar *)w;
	int idx = findContainer( w );

	toolBar->removeItem( itemId( idx ) );
	removeContainer( idx );
}

#include "controls.moc"
