/*
Copyright (C) 2004-2007 Patrice Tremblay <tremblaypatrice@yahoo.fr>
			http://www.poplix.info/lipstik

based on plastik:
Copyright (C) 2003 Sandro Giessl <ceebx@users.sourceforge.net>

based on the Keramik configuration dialog:
Copyright (c) 2003 Maksim Orlovich <maksim.orlovich@kdemail.net>

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.

*/

#ifndef LIPSTIK_CONF_H
#define LIPSTIK_CONF_H

class TQCheckBox;

class LipstikStyleConfig: public TQWidget
{
	Q_OBJECT
  
public:
	LipstikStyleConfig(TQWidget* parent);
	~LipstikStyleConfig();

	//This signal and the next two slots are the plugin
	//page interface
signals:
	void changed(bool);

public slots:
	void save();
	void defaults();

	//Everything below this is internal.
protected slots:
	void updateChanged();

protected:
	//We store settings directly in widgets to
	//avoid the hassle of sync'ing things
	TQCheckBox* 	 animateProgressBar;
	TQCheckBox* 	 reverseGradients;

	TQString 	 scrollBarType( int listnr );
	int	   	 scrollBarItem( TQString kSBType );
	TQComboBox* 	 scrollBarStyle;

	TQString 	 scrollBarWidthType( int widthListnr );
	int	   	 scrollBarWidthItem( TQString kSBWidth );
	TQComboBox* 	 scrollBarWidth;

	TQString 	 sliderType( int sliderlistnr );
	int	   	 sliderItem( TQString kSliderType );
	TQComboBox* 	 sliderStyle;

	TQSpinBox*	 menuSpacing;
	TQSpinBox*	 toolBarSpacing;

	TQCheckBox* 	 paintGroove;
	TQCheckBox* 	 sharperMenuGradient;
	TQCheckBox* 	 alterMenuGradients;
	TQCheckBox* 	 menuLeftSideBar;
	TQCheckBox* 	 drawStatusBarFrame;
	TQCheckBox* 	 drawToolBarHandle;
	TQCheckBox* 	 comboboxColored;
	TQCheckBox* 	 coloredMenuBar;
	TQCheckBox* 	 kickerHighlight;
	TQCheckBox* 	 drawTabHighlight;
	TQCheckBox* 	 flatStripe;
	TQCheckBox* 	 compressedMenus;
	TQCheckBox* 	 drawToolBarSeparator;
	TQCheckBox* 	 drawToolBarGradient;
	TQCheckBox* 	 invertBarGrad;
	TQCheckBox*       drawToolBarItemSeparator;
 	TQCheckBox*       drawFocusRect;
 	TQCheckBox*       newKickerButtons;
 	TQCheckBox*       flatHeaders;
 	TQCheckBox*       tickCheckMark;
	TQCheckBox*       drawTriangularExpander;
	TQCheckBox*       inputFocusHighlight;
	TQCheckBox*       customOverHighlightColor;
	KColorButton*    overHighlightColor;

	TQCheckBox*       customMenuStripeColor;
	KColorButton*    menuStripeColor;

	TQCheckBox*       customFocusHighlightColor;
	KColorButton*    focusHighlightColor;
	TQCheckBox*       customCheckMarkColor;
	KColorButton*    checkMarkColor;
	TQCheckBox*       customTabHighlightColor;
	KColorButton*    tabHighlightColor;

	//Original settings, for accurate dirtiness tracking
	bool       origAnimProgressBar;
    	bool       origReverseGradients;
    	bool       origPaintGroove;
    	bool       origSharperMenuGradient;
    	bool       origAlterMenuGradients;
    	bool       origMenuLeftSideBar;
    	bool       origDrawStatusBarFrame;
    	bool       origDrawToolBarHandle;
	bool       origComboboxColored;
	bool       origColoredMenuBar;
	bool       origKickerHighlight;
	bool       origDrawTabHighlight;
    	bool       origFlatStripe;
    	bool       origCompressedMenus;
	bool       origDrawToolBarSeparator;
	bool       origDrawToolBarGradient;
	bool       origInvertBarGrad;
	bool       origDrawToolBarItemSeparator;
 	bool       origDrawFocusRect;
 	bool       origNewKickerButtons;
 	bool       origFlatHeaders;
 	bool       origTickCheckMark;
	bool       origDrawTriangularExpander;
	bool       origInputFocusHighlight;
	bool       origCustomOverHighlightColor;
	TQColor     origOverHighlightColor;

	bool       origCustomMenuStripeColor;
	TQColor     origMenuStripeColor;

	bool       origCustomFocusHighlightColor;
	TQColor     origFocusHighlightColor;
	bool       origCustomCheckMarkColor;
	TQColor     origCheckMarkColor;
	bool       origCustomTabHighlightColor;
	TQColor     origTabHighlightColor;
	TQString    origScrollBarStyle;
	TQString    origScrollBarWidth;
	TQString    origSliderStyle;

	int        origMenuSpacing;
	int        origToolBarSpacing;
};

#endif
