/***************************************************************************
 *   Copyright (C) 2006 by Marco Martin                                    *
 *   notmart@gmail.com                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the Lesser GNU General Public                   *
 *   License as published by the Free Software Foundation;                 *
 *   either version 2 of the License, or (at your option)                  *
 *   any later version.                                                    *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef MENUHANDLER_H
#define MENUHANDLER_H

#include <kservicegroup.h>
#include <kservice.h>
#include <tdelistbox.h>
#include <tdelistview.h>
#include <tdelistviewsearchline.h>
#include <tdeapplication.h>
#include <kiconloader.h>
#include <kpushbutton.h>
#include <tderecentdocument.h>
#include <krun.h>
#include <dcopref.h>
#include <tqheader.h>
#include <tqimage.h>
#include <tqtoolbutton.h>
#include <tqpopupmenu.h>
#include <tqcombobox.h>
#include <kdirwatch.h>
#include <kdirlister.h>
#include <tqlayout.h>
#include <tdefileitem.h>

#include "dmctl.h"
#include "menu.h"
#include "prefs.h"
#include "tastylistview.h"

/**
 @author Marco Martin <notmart@gmail.com>
*/
class MenuHandler : public TQFrame{
    Q_OBJECT

public:
    MenuHandler( TQWidget *parent, Prefs *prefs, char *name=0, WFlags fl=WType_TopLevel );

    ~MenuHandler();

    void readConfig();
    void popup(TQPoint pos);
    void updateConfig();
    void focusNextChild(){focusNextPrevChild(true);}
    void focusPrevChild(){focusNextPrevChild(false);}
    void clearNewInstalledApplications()
     {newInstalledList.clear();newInstalledTimeStamps.clear();
      prefSkel->setNewInstalledApps( newInstalledList );
      prefSkel->setNewInstalledAppsTimeStamps( newInstalledTimeStamps );}

signals:
    void newApplications(int);
    void kickerConfChanged();
    void hidden();

protected:
    virtual bool eventFilter( TQObject *o, TQEvent * e );

    virtual void closeEvent ( TQCloseEvent *e);
    virtual void resizeEvent ( TQResizeEvent *e)
    { TQWidget::resizeEvent(e); menu->leftFrame->setMaximumWidth( (int)((width()-24)/3) ); }
    virtual void mousePressEvent( TQMouseEvent *e);

private:
    typedef TQMap<ulong, TQString> RecentlyUsedMap;
    typedef enum
    {
      Favourites = 0,
      MoreUsed = 1,
      RecentlyUsed = 2,
      RecentDocuments = 3
    } MenuMode;

    RecentlyUsedMap recentlyUsedMap;

    TQStringList moreUsedList, favouriteList;

    Menu * menu;
    MenuMode currentMenuMode;
    TDEIconLoader *iconLoader;
    TQPopupMenu *sessionsMenu;
    bool searchMode;
    Prefs *prefSkel;
    TDEConfig *kickerConf;
    KDirWatch *kickerConfWatch;
    //xdgMenuWatch for applications-kmenuedit.menu xdgMenuLister for all the desktop files
    KDirWatch *xdgMenuWatch;
    KDirLister *xdgMenuLister;
    int firstListing;
    TQStringList oldInstalledList, newInstalledList;
    TQValueList<int> newInstalledTimeStamps;

    TQPixmap bookMarkPix;
    TQVBoxLayout * MenuHandlerLayout;

//configuration items
    int _menuMode;
    TQString _currentCategory;
    int _numRecentEntries;
    int _iconSize1;
    int _iconSize2;
    int _iconSize3;
    int _actionIconSize;
    bool _displaySubText;
    bool _newAppsNotification;
    bool _strigiIntegration;
    double _menuWidth;
    double _menuHeight;
    bool _isNormalWindow;
    bool _showExpander;
    bool _alwaysCollapsed;
    bool _hideOneChild;
    bool _alphabetical;

    typedef TQMap<TQString, KServiceGroup::List> SListMap;
    SListMap sListMap;
    //KServiceGroup::List getServiceGroupList( KServiceGroup *serviceGroup );
    void setupColumns();
    void loadNewInstalledApps();
    void initOldInstalledApps(KServiceGroup::Ptr group);
    void initNewInstalledApps(KServiceGroup::Ptr group);
    void populateList( KServiceGroup *serviceGroup,
                       TastyListView *listView,
                       TastyListViewItem *listItemFather,
                       bool recursive, const TQString & query = NULL );

    void listClicked( TastyListViewItem * listItem, const TQPoint & coord );
    void fillRecentDocuments( );
    void fillMoreUsed( );
    void fillRecentlyUsed( );
    void fillFavourites( );
    void setupDynList( MenuMode mode );
    //FIXME: this thing is UBER HEAVY
    bool searchNewItems(KServiceGroup::Ptr group);

public slots:
    void slotUpdateApplications();

private slots:
    void dynListElemMoved( );
    void dynListClicked( TQListViewItem * listItem, const TQPoint & coord, int c );
    void slotContextMenu(TQListViewItem *listItem, const TQPoint &coord, int c );
    void initializeRecentlyUsed(  );
    void slotModKickerConf();
    void slotApplicationsAdded(const KFileItemList & newItems);
    void slotApplicationRemoved();
    void childListClicked( TQListViewItem * listItem, const TQPoint & coord, int c );
    void rootListClicked( TQListViewItem * listItem, const TQPoint & coord, int c );
    void doLogout();
    void doLock();
    void slotPopulateSessions();
    void slotSessionActivated( int ent );
    void doNewSession( bool lock );
    void runDialog();
    void initializeSearch( const TQString & query );
    void strigiSearch( const TQString & query );
    void clearDynList();
    void menuModeChanged( int index );
    void switchWindowMode();
};

#endif
