
#include "replaygainpluginloader.h"

#include <tqfile.h>

#include <tdelocale.h>


ReplayGainPlugin::ReplayGainPlugin()
{}

ReplayGainPlugin::~ReplayGainPlugin()
{}


ReplayGainPluginLoader::ReplayGainPluginLoader()
{}

ReplayGainPluginLoader::~ReplayGainPluginLoader()
{}

int ReplayGainPluginLoader::verifyFile( TQString fileName )
{
    TQFile opmlFile( fileName );
    if( !opmlFile.open( IO_ReadOnly ) ) {
        return -1;
    }
    if( !domTree.setContent( &opmlFile ) ) {
        return -1;
    }
    opmlFile.close();

    TQDomElement root = domTree.documentElement();
    if( root.attribute("type") != "replaygain" ) return -1;
    int version;
    TQDomNode node;
    node = root.firstChild();
    while( !node.isNull() ) {
        if( node.isElement() && node.nodeName() == "info" ) {
            version = node.toElement().attribute("version","0").toInt();
            break;
        }
    }

    return version;
}

ReplayGainPlugin* ReplayGainPluginLoader::loadFile( TQString fileName )
{
    //int t_int;
    //float t_float;
    //TQString t_str;

    ReplayGainPlugin* plugin = new ReplayGainPlugin();
    plugin->info.version = -1; // if something goes wrong, we can see that by looking at plugin->info.version
    plugin->filePathName = fileName;

    TQFile opmlFile( fileName );
    if( !opmlFile.open( IO_ReadOnly ) ) {
        return plugin;
    }
    if( !domTree.setContent( &opmlFile ) ) {
        return plugin;
    }
    opmlFile.close();

    TQDomElement root = domTree.documentElement();
    if( root.attribute("type") != "replaygain" ) return plugin;
    TQDomNode node;//, sub1Node;
    node = root.firstChild();

    while( !node.isNull() ) {
        if( node.isElement() && node.nodeName() == "info" ) {

            plugin->info.name = node.toElement().attribute("name",i18n("Unknown Name"));
            plugin->info.about = node.toElement().attribute("about",i18n("Sorry, no information available!"));
            plugin->info.author = node.toElement().attribute("author",i18n("Unknown Author"));
            plugin->info.version = node.toElement().attribute("version","0").toInt();

        }
        else if( node.isElement() && node.nodeName() == "replaygain" ) {

            plugin->replaygain.rank = node.toElement().attribute("rank","10").toInt();
            plugin->replaygain.bin = node.toElement().attribute( "bin" );
            plugin->replaygain.param = node.toElement().attribute("param");
            plugin->replaygain.silent_param = node.toElement().attribute("silent_param");
            plugin->replaygain.in_files = node.toElement().attribute("in_files");
            plugin->replaygain.output_single = node.toElement().attribute("output_single");
            plugin->replaygain.output_multiple = node.toElement().attribute("output_multiple");
            plugin->replaygain.mime_types = TQStringList::split( ',', node.toElement().attribute("mime_types","application/octet-stream") );
            plugin->replaygain.force = node.toElement().attribute("force");
            plugin->replaygain.skip = node.toElement().attribute("skip");
            plugin->replaygain.track = node.toElement().attribute("track");
            plugin->replaygain.album = node.toElement().attribute("album");
            plugin->replaygain.remove = node.toElement().attribute("remove");

            /*sub1Node = node.toElement().firstChild(); // obsolete
            while( !sub1Node.isNull() ) {
                if( sub1Node.isElement() && sub1Node.nodeName() == "test" ) {

                    if( sub1Node.toElement().attribute("enabled") == "true" ) plugin->replaygain.test.enabled = true;
                    else plugin->replaygain.test.enabled = false;
                    plugin->replaygain.test.param = sub1Node.toElement().attribute("param");
                    plugin->replaygain.test.output_track = sub1Node.toElement().attribute("output_track");
                    plugin->replaygain.test.output_album = sub1Node.toElement().attribute("output_album");

                }
                sub1Node = sub1Node.nextSibling();
            }*/
        }
        node = node.nextSibling();
    }

    return plugin;
}

