
#include "optionseditor.h"
#include "options.h"
#include "tagengine.h"
#include "filelist.h"
#include "conversionoptions.h"
#include "outputdirectory.h"

#include <tqlayout.h>
#include <tqstring.h>
#include <tqlabel.h>
#include <tqdatetime.h>

#include <tdelocale.h>
#include <kiconloader.h>
#include <kpushbutton.h>
//#include <tdemessagebox.h>
#include <klineedit.h>
#include <kcombobox.h>
#include <knuminput.h>
#include <ktextedit.h>

// TODO add warning, when editing tags and converting to an unsupported file format

OptionsEditor::OptionsEditor( TagEngine* _tagEngine, Config* _config, FileList* _fileList, TQWidget* parent, const char* name, Page startPage )
    : KDialogBase(
        IconList,
        i18n("Options Editor"),
        /*User2 | User1 |*/ Ok,
        Ok, // default button
        parent,
        name,
        false, // modal
        true/*, // separator
        i18n("Next"),
        i18n("Previous")*/
    )
{
    fileList = _fileList;
    config = _config;
    tagEngine = _tagEngine;

    // create an icon loader object for loading icons
    TDEIconLoader* iconLoader = new TDEIconLoader();

    resize( 400, 350 );
    // TODO move the dialog beside the main window
    setIcon( iconLoader->loadIcon("view_text",TDEIcon::Small) );

//     setButtonGuiItem( User2, KGuiItem(i18n("Previous"),iconLoader->loadIconSet("go-previous",TDEIcon::Small,16,true/*KDE3.5,false*/)) );
//     setButtonGuiItem( User1, KGuiItem(i18n("Next"),iconLoader->loadIconSet("go-next",TDEIcon::Small,16,true/*KDE3.5,false*/)) );
    setButtonGuiItem( Ok, KGuiItem(i18n("Close"),iconLoader->loadIconSet("system-log-out",TDEIcon::Small,16,true/*KDE3.5,false*/)) );

    //// options page ////
    conversionOptions = addPage( i18n("Conversion"), i18n("Conversion options"), iconLoader->loadIcon("soundkonverter",TDEIcon::Desktop) );
    // the grid for all widgets in the main window
    TQGridLayout* conversionOptionsGridLayout = new TQGridLayout( conversionOptions, 1, 1, 0, 6, "conversionOptionsGridLayout" );
    // generate the options input area
    options = new Options( config, i18n("Choose your prefered output options and click on \"Close\"!"), conversionOptions, "options" );
    conversionOptionsGridLayout->addWidget( options, 0, 0 );
    connect( options, TQT_SIGNAL(optionsChanged()),
               this, TQT_SLOT(optionsChanged())
             );
    conversionOptionsGridLayout->setRowStretch( 1, 1 );

    lEditOptions = new TQLabel( "", conversionOptions, "lEditOptions" );
    conversionOptionsGridLayout->addWidget( lEditOptions, 2, 0 );
    lEditOptions->setAlignment( TQt::AlignHCenter );
    lEditOptions->hide();
    pEditOptions = new KPushButton( i18n("Edit conversion options"), conversionOptions, "pEditOptions" );
    pEditOptions->setFixedWidth( pEditOptions->sizeHint().width() );
    conversionOptionsGridLayout->addWidget( pEditOptions, 3, 0, TQt::AlignHCenter );
    pEditOptions->hide();
    connect( pEditOptions, TQT_SIGNAL(clicked()),
               this, TQT_SLOT(editOptionsClicked())
             );

    //// tags page ////
    tags = addPage( i18n("Tags"), i18n("Tags"), iconLoader->loadIcon("view_text",TDEIcon::Desktop) );
    // the grid for all widgets in the main window
    TQGridLayout* tagsGridLayout = new TQGridLayout( tags, 1, 1, 0, 6, "tagsGridLayout" );

    // add the inputs
    // add a horizontal box layout for the title and track number
    TQHBoxLayout *titleBox = new TQHBoxLayout( -1, "titleBox" );
    tagsGridLayout->addLayout( titleBox, 0, 1 );
    // and fill it up
    lTitleLabel = new TQLabel( i18n("Title:"), tags, "lTitleLabel" );
    tagsGridLayout->addWidget( lTitleLabel, 0, 0 );
    lTitle = new KLineEdit( tags, "lTitle" );
    titleBox->addWidget( lTitle );
    connect( lTitle, TQT_SIGNAL(textChanged(const TQString&)),
               this, TQT_SLOT(titleChanged(const TQString&))
             );
    pTitleEdit = new KPushButton( " ", tags, "pTitleEdit" );
    pTitleEdit->setPixmap( iconLoader->loadIcon("kwrite",TDEIcon::Small) );
    pTitleEdit->setFixedSize( lTitle->sizeHint().height(), lTitle->sizeHint().height() );
    pTitleEdit->hide();
    titleBox->addWidget( pTitleEdit );
    connect( pTitleEdit, TQT_SIGNAL(clicked()),
               this, TQT_SLOT(editTitleClicked())
             );
    lNumberLabel = new TQLabel( i18n("Track No.:"), tags, "lNumberLabel" );
    titleBox->addWidget( lNumberLabel );
    iNumber = new KIntSpinBox( 0, 999, 1, 1, 10, tags, "iNumber" );
    titleBox->addWidget( iNumber );
    connect( iNumber, TQT_SIGNAL(valueChanged(int)),
               this, TQT_SLOT(numberChanged(int))
             );
    pNumberEdit = new KPushButton( " ", tags, "pNumberEdit" );
    pNumberEdit->setPixmap( iconLoader->loadIcon("kwrite",TDEIcon::Small) );
    pNumberEdit->setFixedSize( iNumber->sizeHint().height(), iNumber->sizeHint().height() );
    pNumberEdit->hide();
    titleBox->addWidget( pNumberEdit );
    connect( pNumberEdit, TQT_SIGNAL(clicked()),
               this, TQT_SLOT(editNumberClicked())
             );

    // add a horizontal box layout for the artist and the composer
    TQHBoxLayout *artistBox = new TQHBoxLayout( -1, "artistBox" );
    tagsGridLayout->addLayout( artistBox, 1, 1 );
    // and fill it up
    lArtistLabel = new TQLabel( i18n("Artist:"), tags, "lArtistLabel" );
    tagsGridLayout->addWidget( lArtistLabel, 1, 0 );
    lArtist = new KLineEdit( tags, "lArtist" );
    artistBox->addWidget( lArtist );
    connect( lArtist, TQT_SIGNAL(textChanged(const TQString&)),
               this, TQT_SLOT(artistChanged(const TQString&))
             );
    pArtistEdit = new KPushButton( " ", tags, "pArtistEdit" );
    pArtistEdit->setPixmap( iconLoader->loadIcon("kwrite",TDEIcon::Small) );
    pArtistEdit->setFixedSize( lArtist->sizeHint().height(), lArtist->sizeHint().height() );
    pArtistEdit->hide();
    artistBox->addWidget( pArtistEdit );
    connect( pArtistEdit, TQT_SIGNAL(clicked()),
               this, TQT_SLOT(editArtistClicked())
             );
    lComposerLabel = new TQLabel( i18n("Composer:"), tags, "lComposerLabel" );
    artistBox->addWidget( lComposerLabel );
    lComposer = new KLineEdit( tags, "lComposer" );
    artistBox->addWidget( lComposer );
    connect( lComposer, TQT_SIGNAL(textChanged(const TQString&)),
               this, TQT_SLOT(composerChanged(const TQString&))
             );
    pComposerEdit = new KPushButton( " ", tags, "pComposerEdit" );
    pComposerEdit->setPixmap( iconLoader->loadIcon("kwrite",TDEIcon::Small) );
    pComposerEdit->setFixedSize( lComposer->sizeHint().height(), lComposer->sizeHint().height() );
    pComposerEdit->hide();
    artistBox->addWidget( pComposerEdit );
    connect( pComposerEdit, TQT_SIGNAL(clicked()),
               this, TQT_SLOT(editComposerClicked())
             );

    // add a horizontal box layout for the album
    TQHBoxLayout *albumBox = new TQHBoxLayout( -1, "albumBox" );
    tagsGridLayout->addLayout( albumBox, 2, 1 );
    // and fill it up
    lAlbumLabel = new TQLabel( i18n("Album:"), tags, "lAlbumLabel" );
    tagsGridLayout->addWidget( lAlbumLabel, 2, 0 );
    lAlbum = new KLineEdit( tags, "lAlbum" );
    albumBox->addWidget( lAlbum );
    connect( lAlbum, TQT_SIGNAL(textChanged(const TQString&)),
               this, TQT_SLOT(albumChanged(const TQString&))
             );
    pAlbumEdit = new KPushButton( " ", tags, "pAlbumEdit" );
    pAlbumEdit->setPixmap( iconLoader->loadIcon("kwrite",TDEIcon::Small) );
    pAlbumEdit->setFixedSize( lAlbum->sizeHint().height(), lAlbum->sizeHint().height() );
    pAlbumEdit->hide();
    albumBox->addWidget( pAlbumEdit );
    connect( pAlbumEdit, TQT_SIGNAL(clicked()),
               this, TQT_SLOT(editAlbumClicked())
             );

    // add a horizontal box layout for the disc number, year and genre
    TQHBoxLayout *albumdataBox = new TQHBoxLayout( -1, "albumdataBox" );
    tagsGridLayout->addLayout( albumdataBox, 3, 1 );
    // and fill it up
    lDiscLabel = new TQLabel( i18n("Disc No.:"), tags, "lDiscLabel" );
    tagsGridLayout->addWidget( lDiscLabel, 3, 0 );
    iDisc = new KIntSpinBox( 0, 99, 1, 1, 10, tags, "iDisc" );
    albumdataBox->addWidget( iDisc );
    connect( iDisc, TQT_SIGNAL(valueChanged(int)),
               this, TQT_SLOT(discChanged(int))
             );
    pDiscEdit = new KPushButton( " ", tags, "pDiscEdit" );
    pDiscEdit->setPixmap( iconLoader->loadIcon("kwrite",TDEIcon::Small) );
    pDiscEdit->setFixedSize( iDisc->sizeHint().height(), iDisc->sizeHint().height() );
    pDiscEdit->hide();
    albumdataBox->addWidget( pDiscEdit );
    connect( pDiscEdit, TQT_SIGNAL(clicked()),
               this, TQT_SLOT(editDiscClicked())
             );
    albumdataBox->addStretch();
    lYearLabel = new TQLabel( i18n("Year:"), tags, "lYearLabel" );
    albumdataBox->addWidget( lYearLabel );
    iYear = new KIntSpinBox( 0, 99999, 1, TQDate::currentDate().year(), 10, tags, "iYear" );
    albumdataBox->addWidget( iYear );
    connect( iYear, TQT_SIGNAL(valueChanged(int)),
               this, TQT_SLOT(yearChanged(int))
             );
    pYearEdit = new KPushButton( " ", tags, "pYearEdit" );
    pYearEdit->setPixmap( iconLoader->loadIcon("kwrite",TDEIcon::Small) );
    pYearEdit->setFixedSize( iYear->sizeHint().height(), iYear->sizeHint().height() );
    pYearEdit->hide();
    albumdataBox->addWidget( pYearEdit );
    connect( pYearEdit, TQT_SIGNAL(clicked()),
               this, TQT_SLOT(editYearClicked())
             );
    albumdataBox->addStretch();
    lGenreLabel = new TQLabel( i18n("Genre:"), tags, "lGenreLabel" );
    albumdataBox->addWidget( lGenreLabel );
    cGenre = new KComboBox( true, tags, "cGenre" );
    cGenre->insertStringList( tagEngine->genreList );
    cGenre->setCurrentText( "" );
    TDECompletion *cGenreCompletion = cGenre->completionObject();
    cGenreCompletion->insertItems( tagEngine->genreList );
    cGenreCompletion->setIgnoreCase( tags );
    albumdataBox->addWidget( cGenre );
    connect( cGenre, TQT_SIGNAL(textChanged(const TQString&)),
               this, TQT_SLOT(genreChanged(const TQString&))
             );
    pGenreEdit = new KPushButton( " ", tags, "pGenreEdit" );
    pGenreEdit->setPixmap( iconLoader->loadIcon("kwrite",TDEIcon::Small) );
    pGenreEdit->setFixedSize( cGenre->sizeHint().height(), cGenre->sizeHint().height() );
    pGenreEdit->hide();
    albumdataBox->addWidget( pGenreEdit );
    connect( pGenreEdit, TQT_SIGNAL(clicked()),
               this, TQT_SLOT(editGenreClicked())
             );

    // add a horizontal box layout for the comment
    TQHBoxLayout *commentBox = new TQHBoxLayout( -1, "commentBox" );
    tagsGridLayout->addLayout( commentBox, 4, 1 );
    // and fill it up
    lCommentLabel = new TQLabel( i18n("Comment:"), tags, "lCommentLabel" );
    tagsGridLayout->addWidget( lCommentLabel, 4, 0 );
    tComment = new KTextEdit( tags, "tComment" );
    commentBox->addWidget( tComment );
    connect( tComment, TQT_SIGNAL(textChanged()),
               this, TQT_SLOT(commentChanged())
             );
    pCommentEdit = new KPushButton( " ", tags, "pCommentEdit" );
    pCommentEdit->setPixmap( iconLoader->loadIcon("kwrite",TDEIcon::Small) );
    pCommentEdit->setFixedSize( lTitle->sizeHint().height(), lTitle->sizeHint().height() );
    pCommentEdit->hide();
    commentBox->addWidget( pCommentEdit );
    connect( pCommentEdit, TQT_SIGNAL(clicked()),
               this, TQT_SLOT(editCommentClicked())
             );
    tagsGridLayout->setRowStretch( 4, 1 );

    lEditTags = new TQLabel( "", tags, "lEditTags" );
    tagsGridLayout->addWidget( lEditTags, 5, 1 );
    lEditTags->setAlignment( TQt::AlignHCenter );
    lEditTags->hide();
    pEditTags = new KPushButton( i18n("Edit tags"), tags, "pEditTags" );
    pEditTags->setFixedWidth( pEditTags->sizeHint().width() );
    tagsGridLayout->addWidget( pEditTags, 6, 1, TQt::AlignHCenter );
    pEditTags->hide();
    connect( pEditTags, TQT_SIGNAL(clicked()),
               this, TQT_SLOT(editTagsClicked())
             );

    // delete the icon loader object
    delete iconLoader;
}

OptionsEditor::~OptionsEditor()
{}

/*void OptionsEditor::moveWindow( int x, int y )
{
    move( x, y );
}*/

void OptionsEditor::setTagInputEnabled( bool enabled )
{
    lTitleLabel->setEnabled( enabled );
    lTitle->setEnabled( enabled );
    pTitleEdit->hide();
    lNumberLabel->setEnabled( enabled );
    iNumber->setEnabled( enabled );
    pNumberEdit->hide();
    lArtistLabel->setEnabled( enabled );
    lArtist->setEnabled( enabled );
    pArtistEdit->hide();
    lComposerLabel->setEnabled( enabled );
    lComposer->setEnabled( enabled );
    pComposerEdit->hide();
    lAlbumLabel->setEnabled( enabled );
    lAlbum->setEnabled( enabled );
    pAlbumEdit->hide();
    lDiscLabel->setEnabled( enabled );
    iDisc->setEnabled( enabled );
    pDiscEdit->hide();
    lYearLabel->setEnabled( enabled );
    iYear->setEnabled( enabled );
    pYearEdit->hide();
    lGenreLabel->setEnabled( enabled );
    cGenre->setEnabled( enabled );
    pGenreEdit->hide();
    lCommentLabel->setEnabled( enabled );
    tComment->setEnabled( enabled );
    tComment->setReadOnly( !enabled );
    pCommentEdit->hide();

    if( !enabled ) {
        lTitle->setText( "" );
        iNumber->setValue( 0 );
        lArtist->setText( "" );
        lComposer->setText( "" );
        lAlbum->setText( "" );
        iDisc->setValue( 0 );
        iYear->setValue( 0 );
        cGenre->setCurrentText( "" );
        tComment->setText( "" );
    }
}

void OptionsEditor::itemsSelected( TQValueList<FileListItem*> items )
{
    for( TQValueList<FileListItem*>::Iterator it = items.begin(); it != items.end(); ) {
        if( (*it)->converting || (*it) == 0 ) it = items.remove( it );
        else it++;
    }

    selectedItems = items;

    if( items.count() == 0 ) {
        setCaption( i18n("No file selected") );
        options->setEnabled( false );
        lEditOptions->hide();
        pEditOptions->hide();
        setTagInputEnabled( false );
        lEditTags->hide();
        pEditTags->hide();
        return;
    }

    options->setEnabled( true );
    lEditOptions->hide();
    pEditOptions->hide();
    setTagInputEnabled( true );
    lEditTags->hide();
    pEditTags->hide();

    if( items.count() == 1 ) {
        setCaption( KURL::decode_string(items.first()->fileName).replace("%2f","/").replace("%%","%") );
        // HACK ...but seems to work...
        // FIXME directory does get set properly
        disconnect( options, TQT_SIGNAL(optionsChanged()), 0, 0 );
        options->setCurrentOptions( items.first()->options );
        connect( options, TQT_SIGNAL(optionsChanged()),
                   this, TQT_SLOT(optionsChanged())
                 );
        if( items.first()->tags == 0 && !items.first()->local ) {
            setTagInputEnabled( false );
            lEditTags->setText( i18n("The tags could not be read, because this file isn't a local one.\n"
            "soundKonverter will try to read the tags, when it is about to convert the file.\n"
            "If you want to edit the tags, you can hit the button below but then soundKonverter will not try\n"
            "to read the tags.") );
            lEditTags->show();
            pEditTags->show();
        }
        else if( items.first()->tags == 0 ) {
            setTagInputEnabled( false );
            lEditTags->setText( i18n("Reading the tags of this file failed.\n"
            "soundKonverter will try to read the tags a second time, when it is about to convert the file.\n"
            "If you want to edit the tags, you can hit the button below but then soundKonverter will not try\n"
            "to read the tags a second time.") );
            lEditTags->show();
            pEditTags->show();
        }
        else {
            lTitle->setText( items.first()->tags->title );
            iNumber->setValue( items.first()->tags->track );
            lArtist->setText( items.first()->tags->artist );
            lComposer->setText( items.first()->tags->composer );
            lAlbum->setText( items.first()->tags->album );
            iDisc->setValue( items.first()->tags->disc );
            iYear->setValue( items.first()->tags->year );
            cGenre->setCurrentText( items.first()->tags->genre );
            tComment->setText( items.first()->tags->comment );
        }
    }
    else {
        setCaption( i18n("%1 Files").arg(items.count()) );
        TQValueList<FileListItem*>::Iterator it = items.begin();
        ConversionOptions cOptions = (*it)->options;
        TQString title = ( (*it)->tags == 0 ) ? "" : (*it)->tags->title;
        int number = ( (*it)->tags == 0 ) ? 0 : (*it)->tags->track;
        TQString artist = ( (*it)->tags == 0 ) ? "" : (*it)->tags->artist;
        TQString composer = ( (*it)->tags == 0 ) ? "" : (*it)->tags->composer;
        TQString album = ( (*it)->tags == 0 ) ? "" : (*it)->tags->album;
        int disc = ( (*it)->tags == 0 ) ? 0 : (*it)->tags->disc;
        int year = ( (*it)->tags == 0 ) ? 0 : (*it)->tags->year;
        TQString genre = ( (*it)->tags == 0 ) ? "" : (*it)->tags->genre;
        TQString comment = ( (*it)->tags == 0 ) ? "" : (*it)->tags->comment;
        while( it != items.end() ) {
            if( !cOptions.nearlyEqual((*it)->options) ) {
                options->setEnabled( false );
                lEditOptions->setText( i18n("You have selected multiple files with different conversion options.\nYou can change the options of all files by hitting the button below.") );
                lEditOptions->show();
                pEditOptions->show();
            }
            if( (*it)->tags == 0 ) {
                setTagInputEnabled( false );
                lEditTags->setText( i18n("Reading the tags of one or more files failed.\n"
                "soundKonverter will try to read the tags a second time, when it is about to convert the files.\n"
                "If you want to edit the tags, you can hit the button below but then soundKonverter will not try\n"
                "to read the tags a second time.") );
                lEditTags->show();
                pEditTags->show();
                it++;
                continue;
            }
            if( title != (*it)->tags->title && lTitle->isEnabled() ) {
                lTitle->setEnabled( false );
                lTitle->setText( "" );
                pTitleEdit->show();
            }
            if( number != (*it)->tags->track && iNumber->isEnabled() ) {
                iNumber->setEnabled( false );
                iNumber->setValue( 1 );
                pNumberEdit->show();
            }
            if( artist != (*it)->tags->artist && lArtist->isEnabled() ) {
                lArtist->setEnabled( false );
                lArtist->setText( "" );
                pArtistEdit->show();
            }
            if( composer != (*it)->tags->composer && lComposer->isEnabled() ) {
                lComposer->setEnabled( false );
                lComposer->setText( "" );
                pComposerEdit->show();
            }
            if( album != (*it)->tags->album && lAlbum->isEnabled() ) {
                lAlbum->setEnabled( false );
                lAlbum->setText( "" );
                pAlbumEdit->show();
            }
            if( disc != (*it)->tags->disc && iDisc->isEnabled() ) {
                iDisc->setEnabled( false );
                iDisc->setValue( 1 );
                pDiscEdit->show();
            }
            if( year != (*it)->tags->year && iYear->isEnabled() ) {
                iYear->setEnabled( false );
                iYear->setValue( TQDate::currentDate().year() );
                pYearEdit->show();
            }
            if( genre != (*it)->tags->genre && cGenre->isEnabled() ) {
                cGenre->setEnabled( false );
                cGenre->setCurrentText( "" );
                pGenreEdit->show();
            }
            if( comment != (*it)->tags->comment && tComment->isEnabled() ) {
                tComment->setEnabled( false );
                tComment->setReadOnly( true );
                tComment->setText( "" );
                pCommentEdit->show();
            }
            it++;
        }
        if( options->isEnabled() ) {
            // HACK ...but seems to work...
            // FIXME directory does get set properly
            disconnect( options, TQT_SIGNAL(optionsChanged()), 0, 0 );
            options->setCurrentOptions( items.first()->options );
            connect( options, TQT_SIGNAL(optionsChanged()),
                       this, TQT_SLOT(optionsChanged())
                     );
        }
        if( lTitle->isEnabled() ) {
            lTitle->setText( title );
        }
        if( iNumber->isEnabled() ) {
            iNumber->setValue( number );
        }
        if( lArtist->isEnabled() ) {
            lArtist->setText( artist );
        }
        if( lComposer->isEnabled() ) {
            lComposer->setText( composer );
        }
        if( lAlbum->isEnabled() ) {
            lAlbum->setText( album );
        }
        if( iDisc->isEnabled() ) {
            iDisc->setValue( disc );
        }
        if( iYear->isEnabled() ) {
            iYear->setValue( year );
        }
        if( cGenre->isEnabled() ) {
            cGenre->setCurrentText( genre );
        }
        if( tComment->isEnabled() ) {
            tComment->setText( comment );
        }
    }
}

void OptionsEditor::setPreviousEnabled( bool enabled )
{
    enableButton( User2, enabled );
}

void OptionsEditor::setNextEnabled( bool enabled )
{
    enableButton( User1, enabled );
}


void OptionsEditor::optionsChanged()
{
    if( !options->isEnabled() ) return;

    TQString filePathName;
//     TQString outputFilePathName;

    for( TQValueList<FileListItem*>::Iterator it = selectedItems.begin(); it != selectedItems.end(); ++it ) {
        filePathName = (*it)->options.filePathName;
//         outputFilePathName = (*it)->options.outputFilePathName;
        (*it)->options = options->getCurrentOptions();
        (*it)->options.filePathName = filePathName;
//         (*it)->options.outputFilePathName = outputFilePathName;
        //(*it)->updateOptionsCell();
        //(*it)->updateOutputCell();
        fileList->updateItem( *it );
    }
}

void OptionsEditor::titleChanged( const TQString& text )
{
    if( !lTitle->isEnabled() ) return;

    for( TQValueList<FileListItem*>::Iterator it = selectedItems.begin(); it != selectedItems.end(); ++it ) {
        (*it)->tags->title = text;
        //(*it)->updateOutputCell();
        fileList->updateItem( *it );
    }
}

void OptionsEditor::numberChanged( int value )
{
    if( !iNumber->isEnabled() ) return;

    for( TQValueList<FileListItem*>::Iterator it = selectedItems.begin(); it != selectedItems.end(); ++it ) {
        (*it)->tags->track = value;
        //(*it)->updateOutputCell();
        fileList->updateItem( *it );
    }
}

void OptionsEditor::artistChanged( const TQString& text )
{
    if( !lArtist->isEnabled() ) return;

    for( TQValueList<FileListItem*>::Iterator it = selectedItems.begin(); it != selectedItems.end(); ++it ) {
        (*it)->tags->artist = text;
        //(*it)->updateOutputCell();
        fileList->updateItem( *it );
    }
}

void OptionsEditor::composerChanged( const TQString& text )
{
    if( !lComposer->isEnabled() ) return;

    for( TQValueList<FileListItem*>::Iterator it = selectedItems.begin(); it != selectedItems.end(); ++it ) {
        (*it)->tags->composer = text;
        //(*it)->updateOutputCell();
        fileList->updateItem( *it );
    }
}

void OptionsEditor::albumChanged( const TQString& text )
{
    if( !lAlbum->isEnabled() ) return;

    for( TQValueList<FileListItem*>::Iterator it = selectedItems.begin(); it != selectedItems.end(); ++it ) {
        (*it)->tags->album = text;
        //(*it)->updateOutputCell();
        fileList->updateItem( *it );
    }
}

void OptionsEditor::discChanged( int value )
{
    if( !iDisc->isEnabled() ) return;

    for( TQValueList<FileListItem*>::Iterator it = selectedItems.begin(); it != selectedItems.end(); ++it ) {
        (*it)->tags->disc = value;
        //(*it)->updateOutputCell();
        fileList->updateItem( *it );
    }
}

void OptionsEditor::yearChanged( int value )
{
    if( !iYear->isEnabled() ) return;

    for( TQValueList<FileListItem*>::Iterator it = selectedItems.begin(); it != selectedItems.end(); ++it ) {
        (*it)->tags->year = value;
        //(*it)->updateOutputCell();
        fileList->updateItem( *it );
    }
}

void OptionsEditor::genreChanged( const TQString& text )
{
    if( !cGenre->isEnabled() ) return;

    for( TQValueList<FileListItem*>::Iterator it = selectedItems.begin(); it != selectedItems.end(); ++it ) {
        (*it)->tags->genre = text;
        //(*it)->updateOutputCell();
        fileList->updateItem( *it );
    }
}

void OptionsEditor::commentChanged()
{
    if( !tComment->isEnabled() ) return;

    TQString text = tComment->text();

    for( TQValueList<FileListItem*>::Iterator it = selectedItems.begin(); it != selectedItems.end(); ++it ) {
        (*it)->tags->comment = text;
        //(*it)->updateOutputCell();
        fileList->updateItem( *it );
    }
}


void OptionsEditor::editTitleClicked()
{
    lTitle->setEnabled( true );
    lTitle->setFocus();
    pTitleEdit->hide();
    titleChanged( lTitle->text() );
}

void OptionsEditor::editNumberClicked()
{
    iNumber->setEnabled( true );
    iNumber->setFocus();
    pNumberEdit->hide();
    numberChanged( iNumber->value() );
}

void OptionsEditor::editArtistClicked()
{
    lArtist->setEnabled( true );
    lArtist->setFocus();
    pArtistEdit->hide();
    artistChanged( lArtist->text() );
}

void OptionsEditor::editComposerClicked()
{
    lComposer->setEnabled( true );
    lComposer->setFocus();
    pComposerEdit->hide();
    composerChanged( lComposer->text() );
}

void OptionsEditor::editAlbumClicked()
{
    lAlbum->setEnabled( true );
    lAlbum->setFocus();
    pAlbumEdit->hide();
    albumChanged( lAlbum->text() );
}

void OptionsEditor::editDiscClicked()
{
    iDisc->setEnabled( true );
    iDisc->setFocus();
    pDiscEdit->hide();
    discChanged( iDisc->value() );
}

void OptionsEditor::editYearClicked()
{
    iYear->setEnabled( true );
    iYear->setFocus();
    pYearEdit->hide();
    yearChanged( iYear->value() );
}

void OptionsEditor::editGenreClicked()
{
    cGenre->setEnabled( true );
    cGenre->setFocus();
    pGenreEdit->hide();
    genreChanged( cGenre->currentText() );
}

void OptionsEditor::editCommentClicked()
{
    tComment->setEnabled( true );
    tComment->setReadOnly( false );
    tComment->setFocus();
    pCommentEdit->hide();
    commentChanged();
}


void OptionsEditor::editOptionsClicked()
{
    // TODO set default / first profile (use config values)
    options->setProfile( i18n("Medium") );
    options->setFormat( "ogg" );
    options->setEnabled( true );
    lEditOptions->hide();
    pEditOptions->hide();
    optionsChanged();
}

void OptionsEditor::editTagsClicked()
{
    for( TQValueList<FileListItem*>::Iterator it = selectedItems.begin(); it != selectedItems.end(); ++it ) {
        (*it)->tags = new TagData();
    }

    itemsSelected( selectedItems );
}

