/*
   Copyright (C) 2000 Michael Matz <matz@kde.org>
   Modified 2006 Daniel Faust <hessijames@gmail.com>, thx Michael

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef CDDB_H
#define CDDB_H

#include <tqcstring.h>
#include <tqvaluelist.h>
#include <tqstringlist.h>
#include <tqobject.h>

class TQFile;
class TQTextStream;
class KExtendedSocket;

class CDDB : public TQObject
{
    Q_OBJECT
  
public:
    CDDB();
    ~CDDB();
    bool set_server(const char *hostname = 0, unsigned short int port = 0);
    void add_cddb_dirs(const TQStringList& list);
    void save_cddb (bool save) { save_local = save; }
    unsigned int get_discid(TQValueList<int>& track_ofs);
    bool queryCD(TQValueList<int>& track_ofs);
    TQString title() const { return m_title.utf8(); }
    TQString artist(int i) const;
    int trackCount() const { return m_tracks; }
    TQString track(int i) const;
    int disc() const { return m_disc; }
    TQString genre() const { return m_genre.utf8(); }
    int year() const { return m_year; }

private:
    bool readLine(TQCString& s);
    bool writeLine(const TQCString& s);
    bool deinit();
    bool parse_read_resp(TQTextStream*, TQTextStream*);
    bool searchLocal(unsigned int id, TQFile *ret_file);
    KExtendedSocket *ks;
    TQCString h_name;
    unsigned short int port;
    bool remote;
    bool save_local;
    TQStringList cddb_dirs;
    TQCString buf;
    unsigned int m_discid;

    int m_tracks;
    int m_disc;
    int m_year;
    TQString m_genre;
    TQString m_title;
    TQString m_artist;
    TQStringList m_artists;
    TQStringList m_names;

signals:
    void cddbMessage( TQString );
};

#endif // CDDB_H
