

#ifndef OPTIONS_H
#define OPTIONS_H

#include <tqwidget.h>

#include "conversionoptions.h"

#include <tdeio/jobclasses.h>

class OptionsSimple;
class OptionsDetailed;
class Config;

class TQStringList;
class KTabWidget;
class KPushButton;


/**
 * All we need to know about a profile
 */
struct ProfileData
{
    TQString name;
    ConversionOptions options;
};


/**
 * The data pool
 */
// struct OptionsData
// {
//     TQString name;
//     ConversionOptions options;
// };


/**
 * @short The widget, where we can set our output options
 * @author Daniel Faust <hessijames@gmail.com>
 * @version 0.3
 */
class Options : public TQWidget
{
    Q_OBJECT
  
public:
    /**
     * Constructor
     */
    Options( Config*, const TQString &text, TQWidget* parent = 0, const char* name = 0 );

    /**
     * Destructor
     */
    virtual ~Options();

    /**
     * Return the current options
     */
    ConversionOptions getCurrentOptions();

public slots:
    /**
     * Set the current options
     */
    void setCurrentOptions( const ConversionOptions& );

    /**
     * Set the current profile
     */
    void setProfile( const TQString& );

    /**
     * Set the current format
     */
    void setFormat( const TQString& );

    /**
     * Set the current output directory
     */
    void setOutputDirectory( const TQString& );

private:
    /** Toggle between normal and advanced options in the detailed tab */
    KPushButton* pAdvancedOptionsToggle;

    //** Notify the user about new plugins */
//     KPushButton* pPluginsNotify;
    /** Notify the user about new / lost backends */
    KPushButton* pBackendsNotify;

    KTabWidget* tab;

    OutputDirectory* outputDirectory;

    OptionsSimple* optionsSimple;
    OptionsDetailed* optionsDetailed;

    Config *config;

    TDEIO::FileCopyJob* getPluginListJob;

    // /** Copy all options from the detailed tab to the simple tab / find the matching profile */
    //void updateSimpleTab();

private slots:
    void tabChanged( TQWidget* );
    void somethingChanged();
    void configChanged();
//     void getPluginListFinished( TDEIO::Job* job );
//     void showConfigDialogPlugins();
    void showConfigDialogBackends();

signals:
    void optionsChanged();
    void showConfigPluginsPage();
    void showConfigEnvironmentPage();
};

#endif // OPTIONS_H
