###########################################
#                                         #
#  Improvements and feedback are welcome  #
#                                         #
#  This file is released under GPL >= 3   #
#                                         #
###########################################

# required stuff
find_package( TQt )

tde_setup_architecture_flags( )

include(TestBigEndian)
test_big_endian(WORDS_BIGENDIAN)

tde_setup_largefiles( )


##### check for gcc visibility support

if( WITH_GCC_VISIBILITY )
  tde_setup_gcc_visibility( )
endif( WITH_GCC_VISIBILITY )


##### check for TDE binary directory

if( NOT DEFINED TDE_PREFIX AND IS_DIRECTORY /opt/trinity )
  set( TDE_PREFIX "/opt/trinity" )
else( )
  set( TDE_PREFIX "/usr" )
endif( )

if( NOT DEFINED KDECONFIG_EXECUTABLE )
  find_program( KDECONFIG_EXECUTABLE
    NAMES tde-config
    HINTS "${TDE_PREFIX}/bin" ${BIN_INSTALL_DIR} )
  if( NOT KDECONFIG_EXECUTABLE )
    tde_message_fatal( "tde-config are NOT found." )
  endif( NOT KDECONFIG_EXECUTABLE )
endif( NOT DEFINED KDECONFIG_EXECUTABLE )

if( NOT DEFINED TRINITY_BIN_PREFIX )
  execute_process(
    COMMAND ${KDECONFIG_EXECUTABLE} --install exe
    OUTPUT_VARIABLE TDE_BIN_DIR
    OUTPUT_STRIP_TRAILING_WHITESPACE
  )
  set( TRINITY_BIN_PREFIX "${TDE_BIN_DIR}" CACHE PATH "" )
  message( STATUS "Found TDE binaries: ${TRINITY_BIN_PREFIX}" )
endif( )


##### check for Perl

find_package( PerlLibs )
if( NOT PERLLIBS_FOUND )
  tde_message_fatal( "Perl is required but not found on your system." )
endif( )

if( NOT DEFINED PERL_PAR_PACKER )
  find_program( PERL_PAR_PACKER pp )
  if( NOT PERL_PAR_PACKER )
    tde_message_fatal( "Perl PAR packer (pp binary) is required but not found on your system." )
  else( )
    message( STATUS "Found Perl PAR packer: ${PERL_PAR_PACKER}" )
  endif( )
endif( )


if( NOT DEFINED PERL_LIB_CHIPCARD )
  find_path( PERL_DIR_CHIPCARD Chipcard
    HINTS
      ${PERL_SITELIB}
      ${PERL_VENDORARCH}
      ${PERL_VENDORLIB}
      ${PERL_ARCHLIB}
      ${PERL_PRIVLIB}
  )
  if( NOT PERL_DIR_CHIPCARD )
    tde_message_fatal( "libpcsc for perl is required but not found on your system." )
  endif( )
  set( PERL_LIB_CHIPCARD "${PERL_DIR_CHIPCARD}/Chipcard" CACHE PATH "" )
  message( STATUS "Found PCSC-perl: ${PERL_LIB_CHIPCARD}" )
endif( )


##### check for crypt
set( CRYPT_LIBRARY crypt )
check_library_exists( ${CRYPT_LIBRARY} crypt "" HAVE_CRYPT )
if( NOT HAVE_CRYPT )
  unset( CRYPT_LIBRARY )
  check_function_exists( crypt LIBC_HAVE_CRYPT )
  if( LIBC_HAVE_CRYPT )
    set( HAVE_CRYPT 1 CACHE INTERNAL "" FORCE )
  endif( LIBC_HAVE_CRYPT )
endif( NOT HAVE_CRYPT )


##### check for pam

if( NOT DEFINED PAM_FOUND )
  find_path( PAM_INCLUDE_DIR NAMES security/pam_appl.h )
  find_library( PAM_LIBRARY pam )
  if( PAM_INCLUDE_DIR AND PAM_LIBRARY )
    set( PAM_FOUND 1 CACHE BOOL "" )
    set( PAM_LIBRARIES ${PAM_LIBRARY} ${CMAKE_DL_LIBS} CACHE INTERNAL "" )
    message( STATUS "Found pam: ${PAM_LIBRARY}" )
  else( )
    tde_message_fatal( "pam is required but not found on your system." )
  endif( )
endif( )
