/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.

    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>

    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.

    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/

#ifndef _RG_HEADERSCONFIGURATIONPAGE_H_
#define _RG_HEADERSCONFIGURATIONPAGE_H_

#include <tqvbox.h>

class TQVBox;
class TQWidget;
class TQLineEdit;
class TDEListView;

namespace Rosegarden
{

class RosegardenGUIDoc;

class HeadersConfigurationPage : public TQVBox
{
    Q_OBJECT
  

public:
    HeadersConfigurationPage(TQWidget *parent = 0,
	       RosegardenGUIDoc *doc = 0);

public slots:
    void apply();

protected slots:
    void slotAddNewProperty();
    void slotDeleteProperty();
 
protected:
    RosegardenGUIDoc *m_doc;
 
    // Header fields
    TQLineEdit *m_editDedication;
    TQLineEdit *m_editTitle;
    TQLineEdit *m_editSubtitle;
    TQLineEdit *m_editSubsubtitle;
    TQLineEdit *m_editPoet;
    TQLineEdit *m_editComposer;
    TQLineEdit *m_editMeter;
    TQLineEdit *m_editOpus;
    TQLineEdit *m_editArranger;
    TQLineEdit *m_editInstrument;
    TQLineEdit *m_editPiece;
    TQLineEdit *m_editCopyright;
    TQLineEdit *m_editTagline;

    TDEListView *m_metadata;
};


}

#endif
